<?php

return [
    'logo' => [
        'type' => 'anomaly.field_type.file',
        "config" => [
            "folders" => ['images'],
            "mode" => "upload",
        ]
    ],
    'color' => [
        'type'   => "anomaly.field_type.colorpicker",
        "config" => [
            "default_value" => '#d43577e0',
        ]
    ],
    'address' => [
        'type' => 'anomaly.field_type.textarea',
        "config" => [
            "default_value" => "1223, Main Street, Anytown New York, 38000 USA",
        ]
    ],
    'phone' => [
        'type' => 'anomaly.field_type.text',
        "config" => [
            'type' => 'tel',
            'mask' => '0(999) 999-9999'
        ]
    ],

    'big_image' => [
        'type' => 'anomaly.field_type.file',
        "config" => [
            "folders" => ['images'],
            "mode" => "upload",
        ]
    ],
    'default_country' => [
        'type' => 'anomaly.field_type.relationship',
        "config" => [
            "related" => \Visiosoft\LocationModule\Country\CountryModel::class,
            'default_value' => 212,
        ]
    ],

    "favicon" => [
        "type" => "anomaly.field_type.file",
        "config" => [
            "folders" => ['favicon'],
            "mode" => "upload",
        ]
    ],

    "zeroPrice" => [
        "type" => "anomaly.field_type.boolean",
        "config" => [
            "default_value" => true,
        ]
    ],

    "campaign_image" => [
        "type"   => "anomaly.field_type.file",
        "config" => [
            "folders" => ['images'],
        ]
    ],

    "campaign_url" => [
        "type"   => "anomaly.field_type.text",
    ],

    "homepage_thumbnail_height" => [
        "type"   => "anomaly.field_type.integer",
        "config" => [
            "default_value" => 250,
            "min"           => 0,
        ]
    ]
];