const fav = {};
fav.checkFav = (id) => {
    $.ajax({
        type: 'get',
        url: '/favs/check_favorites/' + id + "/adv",
        success: function (response) {
            if (response.length > 0) {
                var element = $('.favorites-' + id);
                element.data('fav', true);
                element.addClass('text-danger');
            }
        }
    });
};

$.each($('.product'), function (key, value) {
    var id = $(value).data('id');
    fav.checkFav(id);
});


function changeFavs(id, add = true) {

    var url_type = (add) ? 'add_fav' : 'delete_fav';

    crudAjax({'type': 'adv', 'id': id}, '/favs/' + url_type, 'POST', function (callback) {
        if (callback.success) {
            var element = $('.favorites-' + id);
            element.data('fav', add);
            element.toggleClass('text-danger');
        }
    })
}

$('a.action-favorites').on('click', function () {
    var element = $(this);
    var id = element.data('id');
    var add = (element.data('fav')) ? false : true;
    changeFavs(id, add)
});