<?php namespace Visiosoft\DressTheme\Seed;

use Anomaly\Streams\Platform\Assignment\Contract\AssignmentRepositoryInterface;
use Anomaly\Streams\Platform\Field\Contract\FieldRepositoryInterface;
use Anomaly\Streams\Platform\Stream\Contract\StreamRepositoryInterface;
use Illuminate\Database\Seeder;


class RepeaterSeeder extends Seeder
{
    protected $streamRepository;
    protected $fieldsRepository;
    protected $assignmentsRepository;

    public function __construct(
        StreamRepositoryInterface $streamRepository,
        FieldRepositoryInterface $fieldsRepository,
        AssignmentRepositoryInterface $assignmentsRepository
    )
    {
        $this->streamRepository = $streamRepository;
        $this->fieldsRepository = $fieldsRepository;
        $this->assignmentsRepository = $assignmentsRepository;
    }

    public function run()
    {
        //Collect repeater
        $repeaters = [
            'showcase_dopings_repeater' => [
                'content' => [
                    'name' => 'Showcase Doping Repeater',
                    'namespace' => 'repeater',
                    'slug' => 'showcase_dopings_repeater',
                    'translatable' => true,
                ],
                'fields' => ['header_text', 'footer_text', 'image', 'url','color']
            ],
            'showcase_middle_repeater' => [
                'content' => [
                    'name' => 'Showcase Middle Repeater',
                    'namespace' => 'repeater',
                    'slug' => 'showcase_middle_repeater',
                    'translatable' => true,
                ],
                'fields' => ['header_text', 'footer_text', 'image', 'url','color']
            ],
            'showcase_banner' => [
                'content' => [
                    'name' => 'Banner Showcase',
                    'namespace' => 'repeater',
                    'slug' => 'showcase_banner',
                    'translatable' => true,
                ],
                'fields' => ['header_text', 'footer_text', 'image', 'url','color']
            ]
        ];

        // Collect Repeater Fields
        $repeater_fields = [
            'header_text' => [
                'field_attributes' => [
                    'name' => 'Header Text',
                    'namespace' => 'repeater',
                    'slug' => 'header_text',
                    'type' => 'anomaly.field_type.text',
                    'locked' => 0,
                    'config' => [],
                ],
                'assignment_attributes' => [
                    'required' => true,
                    'translatable' => true,
                ]
            ],
            'footer_text' => [
                'field_attributes' => [
                    'name' => 'Footer Text',
                    'namespace' => 'repeater',
                    'slug' => 'footer_text',
                    'type' => 'anomaly.field_type.text',
                    'locked' => 0,
                    'config' => [],
                ],
                'assignment_attributes' => [
                    'required' => true,
                    'translatable' => true,
                ]

            ],
            'image_url' => [
                'field_attributes' => [
                    'name' => 'Image URL',
                    'namespace' => 'repeater',
                    'slug' => 'image_url',
                    'type' => 'anomaly.field_type.url',
                    'locked' => 0,
                    'config' => [],
                ],
                'assignment_attributes' => [
                    'required' => true
                ]

            ],
            'showcase_image' => [
                'field_attributes' => [
                    'name' => 'Showcase Image',
                    'namespace' => 'repeater',
                    'slug' => 'showcase_image',
                    'type' => 'anomaly.field_type.file',
                    'locked' => 0,
                    'config' => [
                        'folders' => ['images'],
                        'mode' => 'upload',
                    ],
                ],
                'assignment_attributes' => [
                    'required' => true,
                    'translatable' => false,
                ],
            ],
            'color' => [
                'field_attributes' => [
                    'name' => 'Color',
                    'namespace' => 'repeater',
                    'slug' => 'color',
                    'type' => 'anomaly.field_type.colorpicker',
                    'locked' => 0,
                    'config' => [],
                ],
                'assignment_attributes' => [
                    'required' => true,
                ]
            ]

        ];

        foreach ($repeaters as $slug => $repeater) {
            if (!$repeater_stream = $this->streamRepository->findBySlugAndNamespace($slug, 'repeater')) {
                $repeater_stream = $this->streamRepository->create($repeater['content']);
            }

            foreach ($repeater_fields as $field_slug => $field_repeater) {
                if (!$field = $this->fieldsRepository->findBySlugAndNamespace($field_slug, 'repeater')) {
                    $field = $this->fieldsRepository->create($field_repeater['field_attributes']);
                }

                if (!$this->assignmentsRepository->findByStreamAndField($repeater_stream, $field)) {
                    $this->assignmentsRepository->create(
                        array_merge([
                            'stream' => $repeater_stream,
                            'field' => $field,
                        ], $field_repeater['assignment_attributes'])
                    );
                }
            }
        }
    }

}