<?php namespace Visiosoft\FloristTheme\SettingHandler;

use Anomaly\CheckboxesFieldType\CheckboxesFieldType;
use Visiosoft\CatsModule\Category\Contract\CategoryRepositoryInterface;

class CategoriesOptions
{
    private $categoryRepository;

    public function __construct(CategoryRepositoryInterface $categoryRepository)
    {
        $this->categoryRepository = $categoryRepository;
    }

    public function handle(CheckboxesFieldType $fieldType)
    {
        $categories = $this->categoryRepository->newQuery()->whereNull('parent_category_id')->get()->pluck('name','id');
        $fieldType->setOptions($categories->toArray());
    }

}