<?php namespace Visiosoft\FirebasePushnotificationExtension;

use Anomaly\Streams\Platform\Addon\Extension\Extension;
use Kreait\Firebase\Messaging\CloudMessage;
use Kreait\Firebase\Messaging\Notification;
use Visiosoft\PushnotificationsModule\Helpers\ClientTokens;
use Visiosoft\PushnotificationsModule\Helpers\NotificationContents;
use Visiosoft\PushnotificationsModule\Helpers\NotificationSendResponse;

class FirebasePushnotificationExtension extends Extension
{
    protected $provides = 'visiosoft.module.pushnotification::provider.firebase';

    public function send(NotificationContents $contents, ClientTokens $clientTokens): NotificationSendResponse
    {
        $contents = $contents->getContents();
        foreach ($contents as $content) {
            $messaging = app('firebase.messaging');
            $message = CloudMessage::new()->withNotification(Notification::create($content->title, $content->message));
            $messaging->sendMulticast($message, $clientTokens->getTokens());
        }
        return new NotificationSendResponse();
    }
}
