# Firebase cloud messaging extension

This is extension provided for `pushnotifications-module`

## Installation
```bash
composer composer require kreait/laravel-firebase
```

```bash
php artisan addon:install firebase_pushnotification
```

## Configuration

Get your Firebase credential JSON file and place it on this path or a secure place
If you don't already have generated a Service Account, you can do so by following the instructions from the official documentation pages at https://firebase.google.com/docs/admin/setup#initialize_the_sdk.
```text
storage/streams/default/firebase-auth.json
```

if you change your default path then you have to change the below code in `FirebasePushnotificationExtensionServiceProvider.php`

under register function
```php
public function register()
{
    TODO:// secure your firestore credential file
    Config::set('firebase.projects.app.credentials', 'storage/streams/default/firebase-auth.json');
}
```

## Usages

```php
    $user = UserModel::select(['id', 'deleted_at', 'notification_user_id'])->whereNull('deleted_at')->whereNotNull('notification_user_id')->find(8);
    //FCM = notification_user_id
    $contents = new NotificationContents();
    $contents->setContent('Hello', 'World!');// title, Body
    $tokens = new ClientTokens(); // FCM
    $tokens->setToken($user->getNotificationUserId());
    $pushNotification = new PushNotification();
    $pushNotification->send($contents, $tokens);
```

### References

https://github.com/kreait/laravel-firebase
https://firebase-php.readthedocs.io/en/latest/overview.html