(function (window, document) {


  // Navbar Scroll function
  var lastScrollTop = 0;
  const scrollNum = () => {
    const navbar = document.querySelector('.federal-navbar');
    const mobileNavbar = document.getElementById('navbarCollapse');
    var st = window.pageYOffset || document.documentElement.scrollTop;
    if (st > lastScrollTop) {
      // downscroll code
      navbar.classList.add('active')
      navbar.classList.remove('active-up')
      mobileNavbar.classList.remove('show')
    } else if (st < lastScrollTop) {
        // upscroll code
      if (st === 0) return navbar.classList.remove('active-up')
      navbar.classList.remove('active')
      navbar.classList.add('active-up')
    }
    lastScrollTop = st <= 0 ? 0 : st;
  }

  // Navbar Scroll Event
  window.addEventListener("scroll", scrollNum, false)


  //home capabilities slider splide
  const sliderDom = document.querySelector('#capabilities_slider')
  if(sliderDom) {
    const capabilities = new Splide('#capabilities_slider',{
      perPage: 3,
      perMove: 1,
      gap:20,
      breakpoints: {
        992: {
          perPage: 2,
        },
        768: {
          perPage: 1,
        }
      }
    })
    capabilities.mount()
  }

  //modal control for manufacture page
  const modal = document.querySelector('.modal-manufacture')
  if(modal) {
    document.addEventListener('DOMContentLoaded', function() {
      var openModalButton = document.getElementById('openModal');
      openModalButton.addEventListener('click', function() {
        var modal = document.getElementById('manufactureModal');
        var content = this.getAttribute('data-content');
        var bgImage = this.getAttribute('data-bg-image');
        var title = this.getAttribute('data-title');
        modal.querySelector('.modal-body .content').innerHTML = content;
        modal.querySelector('.modal-body .title').innerHTML = title;
        modal.querySelector('.modal-content').style.background = "linear-gradient(0deg, #15141C 0%, #15141C05 100%), " + bgImage + " center";
      });
    });
  }
    
})(window, document);
