(function (window, document) {


  // Navbar Scroll function
  const scrollNum = () => {
    const navbar = document.querySelector('.federal-navbar')
    if(window.scrollY >= 50) {
      navbar.classList.add('active')
    } else {
      navbar.classList.remove('active')
    }
  }

  // Navbar Scroll Event
  window.addEventListener("scroll", scrollNum)


  //home capabilities slider splide
  const sliderDom = document.querySelector('#capabilities_slider')
  if(sliderDom) {
    const capabilities = new Splide('#capabilities_slider',{
      perPage: 3,
      perMove: 1,
      gap:20,
      breakpoints: {
        992: {
          perPage: 2,
        },
        768: {
          perPage: 1,
        }
      }
    })
    capabilities.mount()
  }

  //modal control for manufacture page
  const modal = document.querySelector('.modal-manufacture')
  if(modal) {
    document.addEventListener('DOMContentLoaded', function() {
      var openModalButton = document.getElementById('openModal');
      openModalButton.addEventListener('click', function() {
        var modal = document.getElementById('manufactureModal');
        var content = this.getAttribute('data-content');
        var bgImage = this.getAttribute('data-bg-image');
        var title = this.getAttribute('data-title');
        modal.querySelector('.modal-body .content').innerHTML = content;
        modal.querySelector('.modal-body .title').innerHTML = title;
        modal.querySelector('.modal-content').style.background = "linear-gradient(0deg, #15141C 0%, #15141C05 100%), " + bgImage + " center";
      });
    });
  }
    
})(window, document);
