function saveFav(id, type, theme) {
    crudAjax({'type': type, 'id': id}, '/favs/add_fav', 'POST', function (callback) {
        $('#' + id).removeClass("add-fav");
        $('#' + id + ' i.far').removeClass("far").addClass("fas");
        if (theme) {
            let removeFromFavTrans = "";
            if (type === 'seller') {
                removeFromFavTrans = removeFromFavSellersTrans
            } else if (type === 'adv') {
                removeFromFavTrans = removeFromFavAdsTrans
            }
            $('#' + id + ' span').text(removeFromFavTrans)
        }
    })
}

function deleteFav(id, type, theme) {
    crudAjax({'type': type, 'id': id}, '/favs/delete_fav', 'POST', function (callback) {
        if (callback.success) {
            $('#' + id).addClass("add-fav");
            $('#' + id + ' i.fas').removeClass("fas").addClass("far");
            if (theme) {
                let addToFavTrans = "";
                if (type === 'seller') {
                    addToFavTrans = addToFavSellersTrans
                } else if (type === 'adv') {
                    addToFavTrans = addToFavAdsTrans
                }
                $('#' + id + ' span').text(addToFavTrans)
            }
        }
    })
}

$('a.add-fav').on('click', function () {
    if ($(this).hasClass('add-fav')) {
        let sah = false;
        if ($(this).hasClass('sah-fav')) {
            sah = true
        }
        saveFav($(this).attr('id'), $(this).attr('data-type'), sah)
    } else {
        let sah = false;
        if ($(this).hasClass('sah-fav')) {
            sah = true
        }
        deleteFav($(this).attr('id'), $(this).attr('data-type'), sah)
    }
});