<?php namespace Visiosoft\FavsModule\Http\Controller;

use Anomaly\Streams\Platform\Http\Controller\PublicController;
use Visiosoft\AdvsModule\Adv\Contract\AdvRepositoryInterface;
use Visiosoft\FavsModule\Favorite\Contract\FavoriteRepositoryInterface;

class AjaxController extends PublicController
{

    private $favoriteRepository;
    protected $advRepository;
    public function __construct(FavoriteRepositoryInterface $favoriteRepository,AdvRepositoryInterface $advRepository)
    {
        parent::__construct();
        $this->favoriteRepository = $favoriteRepository;
        $this->advRepository = $advRepository;
    }

    public function addFavoriteAd()
    {
        if ($this->request->has('ad_id')) {
            $ad_id = $this->request->ad_id;

            //Check is Available Favorites
            if (!count($this->favoriteRepository->checkFav($ad_id, 'adv'))) {
                $item = $this->advRepository->newQuery()->find($this->request->ad_id);
                $name = '';

                if ($item){
                    $name = $item->name;
                }
                $this->favoriteRepository->addFavoriteWithType($ad_id, 'adv', $name);
            }

            return $this->response->json(['status' => true]);
        }
    }

    public function removeFavoriteAd()
    {
        if ($this->request->has('ad_id')) {
            $ad_id = $this->request->ad_id;

            $this->favoriteRepository->removeFavoriteWithType($ad_id, 'adv');

            return $this->response->json(['status' => true]);
        }
        if ($this->request->all) {
            foreach ($this->favoriteRepository->getFavsByUser(auth()->id()) as $fav) {
                $this->favoriteRepository->removeFavoriteWithType($fav->item_id, 'adv');
            }

            return $this->response->json(['status' => true]);
        }
    }

    public function checkFavoriteAd()
    {
        $response = [
            'status' => false,
            'data' => null
        ];

        if ($this->request->has('ad_id')) {

            $ad_id = $this->request->ad_id;

            if (is_array($ad_id)) {
                $entry = $this->favoriteRepository->getMyFavoritesWithType($ad_id, 'adv');

                if (count($entry)) {
                    $response = ['status' => true, 'data' => $entry];
                }
            } else {
                $entry = $this->favoriteRepository->findMyFavoriteWithType($ad_id, 'adv');

                if ($entry) {
                    $response['status'] = true;
                }
            }

            return $response;
        }
    }
}
