<?php namespace Visiosoft\FavsModule\Http\Controller;

use Anomaly\Streams\Platform\Http\Controller\PublicController;
use Anomaly\Streams\Platform\Model\Favs\FavsFavoriteSearchesEntryModel;
use Anomaly\Streams\Platform\Model\Favs\FavsFavoritesEntryModel;
use Illuminate\Foundation\Auth\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Visiosoft\FavsModule\Favorite\Contract\FavoriteRepositoryInterface;
use Visiosoft\FavsModule\Favorite\FavoriteModel;
use Visiosoft\FavsModule\FavoriteSearch\FavoriteSearchModel;
use Visiosoft\ProfileModule\Profile\ProfileModel;

/**
 * Created by PhpStorm.
 * User: emeksancar
 * Date: 24.10.2018
 * Time: 14:20
 */

class FavsController extends PublicController {

    public function __construct(FavoriteRepositoryInterface $favoriteRepository)
    {
        $this->repo = $favoriteRepository;
    }

    public function store($id, $type) {
        if (!Auth::user()) {
            redirect('/login?redirect=' . url()->current())->send();
        }
        $fav = new FavoriteModel();
        $item = $this->repo->getItem($id,$type);
        $save = array();
        $fav->type = $type;
        $fav->item_id = $id;
        if ($type == 'adv') {
            $name = 'name';
        } elseif($type == 'seller') {
            $name ='username';
        } else {

        }
        $fav->item_name = $item->$name;
        if ($fav->save()) {
            return back();
        } else {
            return response()->json([
                'success' => false
            ]);
        }
    }
    public function show() {
        $user = auth()->user();
        $advs = $this->repo->getFavsByUser($user->id);

        return $advs;
    }
    public function destroy($id, $type) {
        $user = auth()->user();
        if ($type == 'search') {
            $fav = $this->repo->getFavoriteSearches($id);
        } else {
            $fav = $this->repo->getSingleFav($id);
        }
        if ($fav != null) {
            if($fav->created_by_id == $user->id) {
                $fav->delete();
                return back();
            } else {
                return trans('visiosoft.module.favs::field.different_user');
            }
        } else {
            return trans('visiosoft.module.favs::field.no_ad');
        }

    }
    public function check($id, $type) {
        if ($type == 'adv') {
            return $this->repo->checkFav($id, $type);
        } elseif ($type == 'seller') {
            return $this->repo->checkFav($id, $type);
        } else{
            return null;
        }
    }

    public function saveSearch(Request $request) {
        if (!Auth::user()) {
            redirect('/login?redirect=' . url()->current())->send();
        }
        $form = new FavoriteSearchModel();
        $form->item_link = $request->url;
        $form->item_name = $request->item_name;
        if ($form->save()) {
            $message = array();
            $message[] = trans('visiosoft.module.advs::field.search_save');
            return redirect()->back()->with('success', $message);
        } else {
            return back()->withErrors('error');
        }
    }
}
