<?php namespace Visiosoft\FavsModule\Favorite;

use Anomaly\Streams\Platform\Model\Advs\AdvsAdvsEntryModel;
use Anomaly\Streams\Platform\Model\Favs\FavsFavoriteSearchesEntryModel;
use Anomaly\Streams\Platform\Model\Favs\FavsFavoritesEntryModel;
use Anomaly\Streams\Platform\Model\Users\UsersUsersEntryModel;
use Visiosoft\AdvsModule\Adv\AdvModel;
use Visiosoft\FavsModule\Favorite\Contract\FavoriteRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;
use Visiosoft\FavsModule\FavoriteSearch\FavoriteSearchModel;

class FavoriteRepository extends EntryRepository implements FavoriteRepositoryInterface
{

    /**
     * The entry model.
     *
     * @var FavoriteModel
     */
    protected $model;

    /**
     * Create a new FavoriteRepository instance.
     *
     * @param FavoriteModel $model
     */
    public function __construct(FavoriteModel $model)
    {
        $this->model = $model;
    }

    public function getItem($id, $type)
    {
        switch ($type) {
            case "adv":
                return AdvsAdvsEntryModel::query()->where('advs_advs.id', $id)->first();
            case "seller":
                return UsersUsersEntryModel::query()->where('users_users.id', $id)->first();
            default:
                return null;
        }
    }

    public function checkFav($id, $type)
    {
       return $this->model->query()
            ->where('favs_favorites.item_id', $id)
            ->where('favs_favorites.created_by_id', auth()->user()->id)
            ->where('favs_favorites.type', $type)
            ->get();
    }

    public function getItems($id, $type)
    {
        return $this->model->getItems($id,$type);
    }

    public function getFavsByUser($id)
    {
        return FavsFavoritesEntryModel::query()->where('favs_favorites.created_by_id', $id)->get();
    }

    public function getFavoriteSearches($id)
    {
        return FavsFavoriteSearchesEntryModel::query()->where('favs_favorite_searches.id', $id)->first();
    }

    public function getSingleFav($id)
    {
        return FavsFavoritesEntryModel::query()->where('item_id', $id)->first();
    }
}
