<?php namespace Visiosoft\FavsModule\Favorite;

use Anomaly\Streams\Platform\Model\Advs\AdvsAdvsEntryModel;
use Anomaly\Streams\Platform\Model\Favs\FavsFavoriteSearchesEntryModel;
use Anomaly\Streams\Platform\Model\Favs\FavsFavoritesEntryModel;
use Anomaly\Streams\Platform\Model\Users\UsersUsersEntryModel;
use Anomaly\UsersModule\User\Contract\UserRepositoryInterface;
use Illuminate\Support\Facades\Auth;
use Visiosoft\AdvsModule\Adv\Contract\AdvRepositoryInterface;
use Visiosoft\FavsModule\Favorite\Contract\FavoriteRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;
use Visiosoft\FavsModule\FavoriteSearch\Contract\FavoriteSearchRepositoryInterface;

class FavoriteRepository extends EntryRepository implements FavoriteRepositoryInterface
{

    /**
     * The entry model.
     *
     * @var FavoriteModel
     */
    protected $model;
    protected $advRepository;
    protected $userRepository;
    protected $favoriteSearchRepository;

    /**
     * Create a new FavoriteRepository instance.
     *
     * @param FavoriteModel $model
     * @param AdvRepositoryInterface $advRepository
     * @param UserRepositoryInterface $userRepository
     * @param FavoriteSearchRepositoryInterface $favoriteSearchRepository
     */
    public function __construct(
        FavoriteModel $model,
        AdvRepositoryInterface $advRepository,
        UserRepositoryInterface $userRepository,
        FavoriteSearchRepositoryInterface $favoriteSearchRepository
    )
    {
        $this->model = $model;
        $this->advRepository = $advRepository;
        $this->userRepository = $userRepository;
        $this->favoriteSearchRepository = $favoriteSearchRepository;
    }

    public function getItem($id, $type)
    {
        switch ($type) {
            case "adv":
                return AdvsAdvsEntryModel::query()->where('advs_advs.id', $id)->first();
            case "seller":
                return UsersUsersEntryModel::query()->where('users_users.id', $id)->first();
            default:
                return null;
        }
    }

    public function getItems($id, $type)
    {
        switch ($type) {
            case "adv":
                $itemIds = $this
                    ->newQuery()
                    ->where('created_by_id', $id)
                    ->where('type', $type)
                    ->pluck('item_id');
                $ads = $this->advRepository->newQuery()->whereIn('advs_advs.id', $itemIds)->get();
                return $this->advRepository->addAttributes($ads);
            case "seller":
                $itemIds = $this
                    ->newQuery()
                    ->where('created_by_id', $id)
                    ->where('type', $type)
                    ->pluck('item_id');
                $users = $this->userRepository->newQuery()->whereIn('id', $itemIds)->get();
                return $users;
            case "search":
                return $this->favoriteSearchRepository->newQuery()->where('created_by_id', $id)->get();
            default:
                return null;
        }
    }

    public function checkFav($id, $type)
    {
        return $this->model->query()
            ->where('favs_favorites.item_id', $id)
            ->whereNotNull('favs_favorites.created_by_id')
            ->where('favs_favorites.created_by_id', auth()->id())
            ->where('favs_favorites.type', $type)
            ->get();
    }

    public function getFavsByUser($id)
    {
        return FavsFavoritesEntryModel::query()->where('favs_favorites.created_by_id', $id)->get();
    }

    public function getFavoriteSearches($id)
    {
        return FavsFavoriteSearchesEntryModel::query()->where('favs_favorite_searches.id', $id)->first();
    }

    public function getSingleFav($id)
    {
        return FavsFavoritesEntryModel::query()->where('item_id', $id)->first();
    }

    public function addFavoriteWithType($item_id, $type)
    {
        return $this->newQuery()->create([
            'item_id' => $item_id,
            'type' => $type,
        ]);
    }

    public function removeFavoriteWithType($item_id, $type)
    {
        $query = $this->newQuery()->where('created_by_id', Auth::id())
            ->where('type', $type)
            ->where('item_id', $item_id);

        if ($query->count()) {
            $query->delete();
        }
    }

    public function getMyFavoritesWithType(array $items, $type)
    {
        $entries = $this->newQuery()->whereIn('item_id', $items)
            ->where('created_by_id', Auth::id())
            ->where('type', $type)
            ->get()->pluck('item_id')->all();

        return $entries;
    }

    public function findMyFavoriteWithType($item_id, $type)
    {
        return $this->newQuery()->where('item_id', $item_id)
            ->where('created_by_id', Auth::id())
            ->where('type', $type)
            ->first();
    }
}
