<?php namespace Visiosoft\FavsModule\Favorite;

use Anomaly\Streams\Platform\Model\Users\UsersUsersEntryModel;
use Visiosoft\AdvsModule\Adv\AdvModel;
use Visiosoft\FavsModule\Favorite\Contract\FavoriteInterface;
use Anomaly\Streams\Platform\Model\Favs\FavsFavoritesEntryModel;
use Visiosoft\FavsModule\Favorite\Contract\FavoriteRepositoryInterface;
use Visiosoft\FavsModule\FavoriteSearch\FavoriteSearchModel;

class FavoriteModel extends FavsFavoritesEntryModel implements FavoriteInterface
{
    public function getFavsByProfile()
    {
        $favs = FavsFavoritesEntryModel::query()
            ->where('favs_favorites.created_by_id', auth()->user()->id)
            ->where('favs_favorites.type', 'adv')
            ->get();

        return $favs;
    }

    public function getItems($id, $type)
    {
        switch ($type) {
            case "adv":
                $item_ids = $this->query()->where('favs_favorites.created_by_id', $id)->where('type', $type)->pluck('item_id');
                return AdvModel::query()->whereIn('advs_advs.id', $item_ids)->get();
            case "seller":
                $item_ids = $this->query()->where('favs_favorites.created_by_id', $id)->where('type', $type)->pluck('item_id');
                return UsersUsersEntryModel::query()->whereIn('users_users.id', $item_ids)->get();
            case "search":
                return FavoriteSearchModel::query()->where('favs_favorite_searches.created_by_id', $id)->get();
            default:
                return null;
        }
    }
}
