<?php namespace Visiosoft\FavsModule;

use Anomaly\Streams\Platform\Addon\AddonServiceProvider;
use Visiosoft\FavsModule\FavoriteSearch\Contract\FavoriteSearchRepositoryInterface;
use Visiosoft\FavsModule\FavoriteSearch\FavoriteSearchRepository;
use Anomaly\Streams\Platform\Model\Favs\FavsFavoriteSearchesEntryModel;
use Visiosoft\FavsModule\FavoriteSearch\FavoriteSearchModel;
use Visiosoft\FavsModule\Favorite\Contract\FavoriteRepositoryInterface;
use Visiosoft\FavsModule\Favorite\FavoriteRepository;
use Anomaly\Streams\Platform\Model\Favs\FavsFavoritesEntryModel;
use Visiosoft\FavsModule\Favorite\FavoriteModel;

class FavsModuleServiceProvider extends AddonServiceProvider
{
    protected $routes = [
        'admin/favs/favorite_searches' => 'Visiosoft\FavsModule\Http\Controller\Admin\FavoriteSearchesController@index',
        'admin/favs/favorite_searches/create' => 'Visiosoft\FavsModule\Http\Controller\Admin\FavoriteSearchesController@create',
        'admin/favs/favorite_searches/edit/{id}' => 'Visiosoft\FavsModule\Http\Controller\Admin\FavoriteSearchesController@edit',
        'admin/favs' => 'Visiosoft\FavsModule\Http\Controller\Admin\FavoritesController@index',
        'admin/favs/create' => 'Visiosoft\FavsModule\Http\Controller\Admin\FavoritesController@create',
        'admin/favs/edit/{id}' => 'Visiosoft\FavsModule\Http\Controller\Admin\FavoritesController@edit',
        'favs' => [
            'middleware' => 'auth',
            'as' => 'favs::favorites',
            'uses' => 'Visiosoft\FavsModule\Http\Controller\FavsController@index'
        ],
        'favs/add_fav' => [
            'as' => 'visiosoft.module.favs::add_fav',
            'uses' => 'Visiosoft\FavsModule\Http\Controller\FavsController@storeAjax'
        ],
        'favs/add_search' => [
            'as' => 'visiosoft.module.favs::add_search',
            'uses' => 'Visiosoft\FavsModule\Http\Controller\FavsController@saveSearch'
        ],
        'favs/myfavs/{limit?}' => 'Visiosoft\FavsModule\Http\Controller\FavsController@show',
        'favs/saved-searches' => [
            'as' => 'visiosoft.module.favs::saved_searches',
            'uses' => 'Visiosoft\FavsModule\Http\Controller\FavsController@savedSearches',
        ],
        'favs/delete_fav' => [
            'as' => 'remove_fav_adv_ajax',
            'uses' => 'Visiosoft\FavsModule\Http\Controller\FavsController@destroyAjax',
        ],
        'favs/delete_fav/{id}/{type}' => [
            'as' => 'remove_fav_adv',
            'uses' => 'Visiosoft\FavsModule\Http\Controller\FavsController@destroy',
        ],
        'favs/check_favorites/{id}/{type}' => [
            'as' => 'visiosoft.module.favs::check_fav',
            'uses' => 'Visiosoft\FavsModule\Http\Controller\FavsController@check'
        ],

        // Ajax Routes
        'ajax/add-favorite-ad' => [
            'as' => 'visiosoft.module.favs::ajax.add_favorite_ad',
            'uses' => 'Visiosoft\FavsModule\Http\Controller\AjaxController@addFavoriteAd'
        ],
        'ajax/remove-favorite-ad' => [
            'as' => 'visiosoft.module.favs::ajax.remove_favorite_ad',
            'uses' => 'Visiosoft\FavsModule\Http\Controller\AjaxController@removeFavoriteAd'
        ],
        'ajax/check-favorite-ad' => [
            'as' => 'visiosoft.module.favs::ajax.check_favorite_ad',
            'uses' => 'Visiosoft\FavsModule\Http\Controller\AjaxController@checkFavoriteAd'
        ],
    ];

    protected $bindings = [
        FavsFavoriteSearchesEntryModel::class => FavoriteSearchModel::class,
        FavsFavoritesEntryModel::class => FavoriteModel::class,
    ];

    protected $singletons = [
        FavoriteSearchRepositoryInterface::class => FavoriteSearchRepository::class,
        FavoriteRepositoryInterface::class => FavoriteRepository::class,
    ];

    public function boot(FavoriteRepositoryInterface $favoriteRepository)
    {
        view()->composer('visiosoft.module.advs::list/*', function ($view) use ($favoriteRepository) {
            $favs = $favoriteRepository->getItems(auth()->id(), 'adv');

            $view->with('favs', $favs);
        });
    }
}
