<?php namespace Visiosoft\FavsModule;

use Anomaly\Streams\Platform\Addon\AddonServiceProvider;
use Visiosoft\FavsModule\FavoriteSearch\Contract\FavoriteSearchRepositoryInterface;
use Visiosoft\FavsModule\FavoriteSearch\FavoriteSearchRepository;
use Anomaly\Streams\Platform\Model\Favs\FavsFavoriteSearchesEntryModel;
use Visiosoft\FavsModule\FavoriteSearch\FavoriteSearchModel;
use Visiosoft\FavsModule\Favorite\Contract\FavoriteRepositoryInterface;
use Visiosoft\FavsModule\Favorite\FavoriteRepository;
use Anomaly\Streams\Platform\Model\Favs\FavsFavoritesEntryModel;
use Visiosoft\FavsModule\Favorite\FavoriteModel;
use Illuminate\Routing\Router;

class FavsModuleServiceProvider extends AddonServiceProvider
{

    /**
     * Additional addon plugins.
     *
     * @type array|null
     */
    protected $plugins = [];

    /**
     * The addon Artisan commands.
     *
     * @type array|null
     */
    protected $commands = [];

    /**
     * The addon's scheduled commands.
     *
     * @type array|null
     */
    protected $schedules = [];

    /**
     * The addon API routes.
     *
     * @type array|null
     */
    protected $api = [];

    /**
     * The addon routes.
     *
     * @type array|null
     */
    protected $routes = [
        'admin/favs/favorite_searches'           => 'Visiosoft\FavsModule\Http\Controller\Admin\FavoriteSearchesController@index',
        'admin/favs/favorite_searches/create'    => 'Visiosoft\FavsModule\Http\Controller\Admin\FavoriteSearchesController@create',
        'admin/favs/favorite_searches/edit/{id}' => 'Visiosoft\FavsModule\Http\Controller\Admin\FavoriteSearchesController@edit',
        'admin/favs'           => 'Visiosoft\FavsModule\Http\Controller\Admin\FavoritesController@index',
        'admin/favs/create'    => 'Visiosoft\FavsModule\Http\Controller\Admin\FavoritesController@create',
        'admin/favs/edit/{id}' => 'Visiosoft\FavsModule\Http\Controller\Admin\FavoritesController@edit',
        'favs' => [
            'as'   => 'favs::favorites',
            'uses' => 'Visiosoft\FavsModule\Http\Controller\FavsController@index'
        ],
        'favs/add_fav' => [
            'as'   => 'visiosoft.module.favs::add_fav',
            'uses' => 'Visiosoft\FavsModule\Http\Controller\FavsController@storeAjax'
        ],
        'favs/add_search' => [
            'as' => 'visiosoft.module.favs::add_search',
            'uses' => 'Visiosoft\FavsModule\Http\Controller\FavsController@saveSearch'
        ],
        'favs/myfavs' => 'Visiosoft\FavsModule\Http\Controller\FavsController@show',
        'favs/delete_fav' => [
            'as' => 'remove_fav_adv_ajax',
            'uses' => 'Visiosoft\FavsModule\Http\Controller\FavsController@destroyAjax',
        ],
        'favs/delete_fav/{id}/{type}' => [
            'as' => 'remove_fav_adv',
            'uses' => 'Visiosoft\FavsModule\Http\Controller\FavsController@destroy',
        ],
        'favs/check_favorites/{id}/{type}' => [
            'as' => 'visiosoft.module.favs::check_fav',
            'uses' => 'Visiosoft\FavsModule\Http\Controller\FavsController@check'
        ]
    ];

    /**
     * The addon middleware.
     *
     * @type array|null
     */
    protected $middleware = [
        //Visiosoft\FavsModule\Http\Middleware\ExampleMiddleware::class
    ];

    /**
     * Addon group middleware.
     *
     * @var array
     */
    protected $groupMiddleware = [
        //'web' => [
        //    Visiosoft\FavsModule\Http\Middleware\ExampleMiddleware::class,
        //],
    ];

    /**
     * Addon route middleware.
     *
     * @type array|null
     */
    protected $routeMiddleware = [];

    /**
     * The addon event listeners.
     *
     * @type array|null
     */
    protected $listeners = [
        //Visiosoft\FavsModule\Event\ExampleEvent::class => [
        //    Visiosoft\FavsModule\Listener\ExampleListener::class,
        //],
    ];

    /**
     * The addon alias bindings.
     *
     * @type array|null
     */
    protected $aliases = [
        //'Example' => Visiosoft\FavsModule\Example::class
    ];

    /**
     * The addon class bindings.
     *
     * @type array|null
     */
    protected $bindings = [
        FavsFavoriteSearchesEntryModel::class => FavoriteSearchModel::class,
        FavsFavoritesEntryModel::class => FavoriteModel::class,
    ];

    /**
     * The addon singleton bindings.
     *
     * @type array|null
     */
    protected $singletons = [
        FavoriteSearchRepositoryInterface::class => FavoriteSearchRepository::class,
        FavoriteRepositoryInterface::class => FavoriteRepository::class,
    ];

    /**
     * Additional service providers.
     *
     * @type array|null
     */
    protected $providers = [
        //\ExamplePackage\Provider\ExampleProvider::class
    ];

    /**
     * The addon view overrides.
     *
     * @type array|null
     */
    protected $overrides = [
        //'streams::errors/404' => 'module::errors/404',
        //'streams::errors/500' => 'module::errors/500',
    ];

    /**
     * The addon mobile-only view overrides.
     *
     * @type array|null
     */
    protected $mobile = [
        //'streams::errors/404' => 'module::mobile/errors/404',
        //'streams::errors/500' => 'module::mobile/errors/500',
    ];

    /**
     * Register the addon.
     */
    public function register()
    {
        // Run extra pre-boot registration logic here.
        // Use method injection or commands to bring in services.
    }

    /**
     * Boot the addon.
     */
    public function boot()
    {
        // Run extra post-boot registration logic here.
        // Use method injection or commands to bring in services.
    }

    /**
     * Map additional addon routes.
     *
     * @param Router $router
     */
    public function map(Router $router)
    {
        // Register dynamic routes here for example.
        // Use method injection or commands to bring in services.
    }

}
