<?php namespace Visiosoft\FavsModule\Favorite\Table;

use Anomaly\UsersModule\User\Contract\UserRepositoryInterface;
use Visiosoft\FavsModule\Favorite\Table\Filter\CreatedFilterQuery;

class FavoriteTableFilters
{
	public function handle(FavoriteTableBuilder $builder, UserRepositoryInterface $userRepository)
	{
		$users = [];
		foreach ($userRepository->all() as $key => $user){
			$users[$user->id] = $user->first_name . ' ' . $user->last_name;
		}

		$builder->setFilters([
			'item_name',
			'type',
			'created_by' => [
				'exact' => true,
				'filter' => 'select',
				'options' => $users,
				'placeholder' => 'visiosoft.module.favs::field.created_by',
				'query' => CreatedFilterQuery::class,
			]
		]);
	}
}