<?php namespace Visiosoft\FavsModule\Favorite\Table;

use Anomaly\Streams\Platform\Entry\EntryModel;

class FavoriteTableColumns
{
    public function handle(FavoriteTableBuilder $builder)
    {
        $builder->setColumns([
            'id' => 'entry.id',
            'item_name' => [
                'wrapper' => '<a href="{value.href}">{value.name}</a>',
                'value' => [
                    'name' => 'entry.item_name',
                    'href' => function (EntryModel $entry) {
                        return $entry->type === 'adv'
                            ? route('adv_detail', [$entry->item_id])
                            : url('/admin/users/edit/' . $entry->item_id);
                    },
                ],
            ],
            'type',
            'created_by' => 'entry.created_by.name',
        ]);
    }
}
