<?php namespace Visiosoft\FavsModule\Favorite;

use Visiosoft\AdvsModule\Adv\AdvModel;
use Visiosoft\AdvsModule\Adv\Contract\AdvRepositoryInterface;
use Visiosoft\FavsModule\Favorite\Contract\FavoriteInterface;
use Anomaly\Streams\Platform\Model\Favs\FavsFavoritesEntryModel;

class FavoriteModel extends FavsFavoritesEntryModel implements FavoriteInterface
{
    protected $appends = [
        'ad'
    ];

    public function getFavsByProfile()
    {
        $favs = FavsFavoritesEntryModel::query()
            ->where('favs_favorites.created_by_id', auth()->user()->id)
            ->where('favs_favorites.type', 'adv')
            ->get();

        return $favs;
    }

    public function getAdAttribute()
    {
        return app(AdvModel::class)->find($this->item_id);
    }
}
