function crud(params, url, type, callback) {
    $.ajax({
        type: type,
        data: params,
        url: url,
        success: function (response) {
            callback(response);
        },
    });
}

function saveFav(id, type) {
    crud({'type': type, 'id': id}, '/favs/add_fav', 'POST', function (callback) {
        $('#' + id).removeClass("add-fav");
        $('#' + id + ' i.far').removeClass("far").addClass("fas");
    })
}

function deleteFav(id, type) {
    crud({'type': type, 'id': id}, '/favs/delete_fav', 'DELETE', function (callback) {
        console.log(callback)
        if (callback.success) {
            $('#' + id).addClass("add-fav");
            $('#' + id + ' i.fas').removeClass("fas").addClass("far");
        }
    })
}

$('a.add-fav').on('click', function () {
    if ($(this).hasClass('add-fav')) {
        saveFav($(this).attr('id'), $(this).attr('data-type'))
    } else {
        deleteFav($(this).attr('id'), $(this).attr('data-type'))
    }
});