function crud(params, url, type, callback) {
    $.ajax({
        type: type,
        data: params,
        url: url,
        success: function (response) {
            callback(response);
        },
    });
}

function saveFav(id, type, theme) {
    crud({'type': type, 'id': id}, '/favs/add_fav', 'POST', function (callback) {
        $('#' + id).removeClass("add-fav");
        $('#' + id + ' i.far').removeClass("far").addClass("fas");
        if (theme) {
            $('#' + id + ' span').text(removeFromFavTrans)
        }
    })
}

function deleteFav(id, type, theme) {
    crud({'type': type, 'id': id}, '/favs/delete_fav', 'DELETE', function (callback) {
        if (callback.success) {
            $('#' + id).addClass("add-fav");
            $('#' + id + ' i.fas').removeClass("fas").addClass("far");
            if (theme) {
                $('#' + id + ' span').text(addToFavTrans)
            }
        }
    })
}

$('a.add-fav').on('click', function () {
    if ($(this).hasClass('add-fav')) {
        let sah = false;
        if ($(this).hasClass('sah-fav')) {
            sah = true
        }
        saveFav($(this).attr('id'), $(this).attr('data-type'), sah)
    } else {
        let sah = false;
        if ($(this).hasClass('sah-fav')) {
            sah = true
        }
        deleteFav($(this).attr('id'), $(this).attr('data-type'), sah)
    }
});