<?php namespace Visiosoft\FavsModule\Http\Controller;

use Anomaly\Streams\Platform\Http\Controller\PublicController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Visiosoft\FavsModule\Favorite\Contract\FavoriteRepositoryInterface;
use Visiosoft\FavsModule\Favorite\FavoriteModel;
use Visiosoft\FavsModule\FavoriteSearch\FavoriteSearchModel;

/**
 * Created by PhpStorm.
 * User: emeksancar
 * Date: 24.10.2018
 * Time: 14:20
 */

class FavsController extends PublicController {

    private $favoriteRepository;

    public function __construct(FavoriteRepositoryInterface $favoriteRepository)
    {
        parent::__construct();
        $this->favoriteRepository = $favoriteRepository;
    }

    public function index() {
        $id = Auth::id();
        $favAdvs = $this->favoriteRepository->getItems($id, 'adv');
        $favSellers = $this->favoriteRepository->getItems($id, 'seller');
        $favSearches = $this->favoriteRepository->getItems($id, 'search');

        return $this->view->make('visiosoft.module.favs::profile.favorites', compact('favAdvs', 'favSellers', 'favSearches'));
    }

    public function destroy($id, $type) {
        $user = auth()->user();
        if ($type == 'search') {
            $fav = $this->favoriteRepository->getFavoriteSearches($id);
        } else {
            $fav = $this->favoriteRepository->getSingleFav($id);
        }
        if ($fav != null) {
            if($fav->created_by_id == $user->id) {
                $fav->delete();
                return back();
            } else {
                return trans('visiosoft.module.favs::field.different_user');
            }
        } else {
            return trans('visiosoft.module.favs::field.no_ad');
        }

    }

    public function storeAjax(Request $request) {
        if (!\auth()->check()) {
            return response()->json([
                'success' => false
            ]);
        }

        $fav = new FavoriteModel();
        $id = explode('-', $request->id);
        $id = end($id);
        $item = $this->favoriteRepository->getItem($id, $request->type);
        $save = array();
        $fav->type = $request->type;
        $fav->item_id = $id;
        if ($request->type == 'adv') {
            $name = 'name';
        } elseif($request->type == 'seller') {
            $name ='username';
        }
        $fav->item_name = $item->$name;
        if ($fav->save()) {
            return response()->json([
                'success' => true
            ]);
        } else {
            return response()->json([
                'success' => false
            ]);
        }
    }
    public function show() {
        $user = auth()->user();
        $advs = $this->favoriteRepository->getFavsByUser($user->id);

        return $advs;
    }
    public function destroyAjax(Request $request) {
        $user = auth()->user();
        $id = explode('-', $request->id);
        $id = end($id);
        if ($request->type == 'search') {
            $fav = $this->favoriteRepository->getFavoriteSearches($id);
        } else {
            $fav = $this->favoriteRepository->getSingleFav($id);
        }
        if ($fav != null) {
            if($fav->created_by_id == $user->id) {
                $fav->delete();
                return response()->json([
                    'success' => true
                ]);
            } else {
                return response()->json([
                    'success' => false
                ]);
            }
        } else {
            return response()->json([
                'success' => false
            ]);
        }

    }
    public function check($id, $type) {
        if ($type == 'adv') {
            return $this->favoriteRepository->checkFav($id, $type);
        } elseif ($type == 'seller') {
            return $this->favoriteRepository->checkFav($id, $type);
        } else {
            return null;
        }
    }

    public function saveSearch(Request $request) {
        if (!Auth::user()) {
            redirect('/login?redirect=' . url()->current())->send();
        }
        $form = new FavoriteSearchModel();
        $form->item_link = $request->url;
        $form->item_name = $request->item_name;
        if ($form->save()) {
            $message = array();
            $message[] = trans('visiosoft.module.advs::field.search_save');
            return redirect()->back()->with('success', $message);
        } else {
            return back()->withErrors('error');
        }
    }
}
