function saveFav(id, type, theme) {
    crudAjax({'type': type, 'id': id}, '/favs/add_fav', 'POST', function (callback) {
        if (callback.success) {
            $('#' + id).addClass('active');
            if (typeof inMyFavoritesTrans !== 'undefined') {
                $('#' + id).find('p').text(inMyFavoritesTrans)
            }

            $('#' + id + ' i.far').removeClass("far").addClass("fas");
            if (theme) {
                let removeFromFavTrans = "";
                if (type === 'seller') {
                    removeFromFavTrans = removeFromFavSellersTrans
                } else if (type === 'adv') {
                    removeFromFavTrans = removeFromFavAdsTrans
                }
                $('#' + id + ' span').text(removeFromFavTrans)
            }
        }
    })
}

function deleteFav(id, type, theme) {
    crudAjax({'type': type, 'id': id}, '/favs/delete_fav', 'POST', function (callback) {
        if (callback.success) {
            $('#' + id).removeClass('active');
            if (typeof addToMyFavoritesTrans !== 'undefined') {
                $('#' + id).find('p').text(addToMyFavoritesTrans)
            }

            $('#' + id + ' i.fas').removeClass("fas").addClass("far");
            if (theme) {
                let addToFavTrans = "";
                if (type === 'seller') {
                    addToFavTrans = addToFavSellersTrans
                } else if (type === 'adv') {
                    addToFavTrans = addToFavAdsTrans
                }
                $('#' + id + ' span').text(addToFavTrans)
            }
        }
    })
}

$('.add-fav').on('click', function () {
    if ($(this).hasClass('active')) {
        let sah = false;
        if ($(this).hasClass('sah-fav')) {
            sah = true
        }
        deleteFav($(this).attr('id'), $(this).attr('data-type'), sah)
    } else {
        let sah = false;
        if ($(this).hasClass('sah-fav')) {
            sah = true
        }
        saveFav($(this).attr('id'), $(this).attr('data-type'), sah)
    }
});
