<?php namespace Visiosoft\ExchangeModule\Borsa;

use Visiosoft\ExchangeModule\Borsa\Contract\BorsaRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;

class BorsaRepository extends EntryRepository implements BorsaRepositoryInterface
{

    /**
     * The entry model.
     *
     * @var BorsaModel
     */
    protected $model;

    /**
     * Create a new BorsaRepository instance.
     *
     * @param BorsaModel $model
     */
    public function __construct(BorsaModel $model)
    {
        $this->model = $model;
    }

    public function bist100()
    {
        $response = getExchange(setting_value('visiosoft.module.exchange::borsa_url'));

        $entry = $this->newQuery()->create([
            'type' => 'bist100',
            'response_json' => $response
        ]);

        return $entry;
    }

    public function bist100Value()
    {
        $entry = $this->newQuery()
            ->where('type', 'bist100')
            ->orderByDesc('id')
            ->limit(2)->get();


        $value_last = $this->getValue($entry->first());
        $value_first = $this->getValue($entry->last());

        $status = $this->calculateStatus($value_first, $value_last);

        return [
            'status' => $status,
            'value' => $value_last
        ];
    }

    public function getValue($entry)
    {
        $entry = json_decode($entry->response_json, true);
        return reset($entry['result'])['currentstr'];
    }

    public function calculateStatus($first, $last)
    {
        return (($last * 1000) > ($first * 1000)) ? 'increased' : 'decreased';
    }
}
