<?php namespace Visiosoft\ExchangeModule\Currency;

use Visiosoft\ExchangeModule\Currency\Contract\CurrencyRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;

class CurrencyRepository extends EntryRepository implements CurrencyRepositoryInterface
{

    /**
     * The entry model.
     *
     * @var CurrencyModel
     */
    protected $model;
    public $type = 'currency';

    /**
     * Create a new CurrencyRepository instance.
     *
     * @param CurrencyModel $model
     */
    public function __construct(CurrencyModel $model)
    {
        $this->model = $model;
    }

    public function saveCurrency()
    {
        $endpoint = setting_value('visiosoft.module.exchange::currency_url');
        $response = getExchange($endpoint);

        $entry = $this->newQuery()->create([
            'type' => $this->type,
            'response_json' => $response
        ]);
        return $entry;
    }

    public function getValueFromDb()
    {

        $entry = $this->newQuery()
            ->where('type',  $this->type)
            ->orderByDesc('id')
            ->limit(2)->get();

        $value_last = $this->getValue($entry->first());
        $value_first = $this->getValue($entry->last());

        $status_usd = $this->calculateStatus($value_first[0], $value_last[0]);
        $status_euro = $this->calculateStatus($value_first[1], $value_last[1]);

        return [
            'type' => $this->type,
            'status_usd' => $status_usd,
            'status_euro' => $status_euro,
            'value' => $value_first
        ];
    }

    public function getValue($entry)
    {
        $entry = json_decode($entry->response_json, true);
        return $entry['result'];
    }

    public function calculateStatus($first, $last)
    {
        return (($last['buying'] * 1000) > ($first['buying'] * 1000)) ? 'increased' : 'decreased';
    }

}
