<?php namespace Visiosoft\EvdepismisTheme\Seeds;

use Anomaly\Streams\Platform\Assignment\Contract\AssignmentRepositoryInterface;
use Anomaly\Streams\Platform\Field\Contract\FieldRepositoryInterface;
use Anomaly\Streams\Platform\Stream\Contract\StreamRepositoryInterface;
use Illuminate\Database\Seeder;

class StoreFieldsSeeder extends Seeder
{
    private $fieldRepository;
    private $assignmentRepository;
    private $streamRepository;

    public function __construct(
        FieldRepositoryInterface $fieldRepository,
        AssignmentRepositoryInterface $assignmentRepository,
        StreamRepositoryInterface $streamRepository
    ) {
        $this->fieldRepository = $fieldRepository;
        $this->assignmentRepository = $assignmentRepository;
        $this->streamRepository = $streamRepository;
    }

    public function run()
    {
        $storeFields = [
            [
                'name' => 'Turkish Identity Number',
                'slug' => 'turkish_id_no',
                'type' => 'anomaly.field_type.integer',
                "config" => [
                    "separator" => "",
                    "min"       => 0,
                ]
            ],
            [
                'name' => 'Discount',
                'slug' => 'discount',
                'type' => 'anomaly.field_type.select',
                "config" => [
                    "options" => <<<DY
10
20
30
40
50
60
70
80
90
100
DY,
                ]
            ],
            [
                'name' => 'Cuisines',
                'slug' => 'cuisines',
                'type' => 'anomaly.field_type.tags',
            ],
            [
                'name' => 'Open Time',
                'slug' => 'open_time',
                'type' => 'anomaly.field_type.datetime',
                "config" => [
                    "mode" => "time",
                    "step" => 1,
                ]
            ],
            [
                'name' => 'Open Time',
                'slug' => 'open_time',
                'type' => 'anomaly.field_type.datetime',
                "config" => [
                    "mode" => "time",
                    "time_format" => "H:i",
                    "step" => 1,
                ]
            ],
            [
                'name' => 'Close Time',
                'slug' => 'close_time',
                'type' => 'anomaly.field_type.datetime',
                "config" => [
                    "mode" => "time",
                    "time_format" => "H:i",
                    "step" => 1,
                ]
            ],
            [
                'name' => 'Close Time',
                'slug' => 'close_time',
                'type' => 'anomaly.field_type.datetime',
                "config" => [
                    "mode" => "time",
                    "time_format" => "H:i",
                    "step" => 1,
                ]
            ],
            [
                'name' => 'Open Days',
                'slug' => 'open_days',
                'type' => 'anomaly.field_type.checkboxes',
                "config" => [
                    "options" => <<<DY
Mon
Tue
Wed
Thu
Fri
Sat
Sun
DY,
                    "mode"    => "tags",
                ]
            ],
            [
                'name' => 'Is Online',
                'slug' => 'is_online',
                'type' => 'anomaly.field_type.boolean',
            ],
            [
                'name' => 'Form of Delivery',
                'slug' => 'form_of_delivery',
                'type' => 'anomaly.field_type.select',
                "config" => [
                    "options" => <<<DY
Come Get It
Home Delivery
DY,
                ]
            ],
            [
                'name' => 'Service Time',
                'slug' => 'service_time',
                'type' => 'anomaly.field_type.integer',
                'instructions' => 'In minutes.',
                "config" => [
                    "separator" => '',
                    "min" => 0,
                    "step" => 1,
                ]
            ],
            [
                'name' => 'Rating',
                'slug' => 'rating',
                'type' => 'visiosoft.field_type.range',
            ],
            [
                'name' => 'Menu',
                'slug' => 'menu',
                'type' => 'anomaly.field_type.files',
                "config" => [
                    "folders" => ['images'],
                    "mode"    => "upload",
                ]
            ],
            [
                'name' => 'Photos',
                'slug' => 'photos',
                'type' => 'anomaly.field_type.files',
                "config" => [
                    "folders" => ['images'],
                    "mode"    => "upload",
                ]
            ],
        ];

        foreach ($storeFields as $storeField) {
            if (!$field = $this->fieldRepository->findBySlugAndNamespace($storeField['slug'], 'store')) {
                $field = $this->fieldRepository->create([
                    'name' => $storeField['name'],
                    'slug' => $storeField['slug'],
                    'type' => $storeField['type'],
                    'namespace' => 'store',
                    'locked' => false,
                    'config' => $storeField['config'] ?? null,
                ]);
            }

            $stream = $this->streamRepository->findBySlugAndNamespace('store', 'store');
            if (!$this->assignmentRepository->findByStreamAndField($stream, $field)) {
                $this->assignmentRepository->create([
                    'field_id' => $field->id,
                    'stream_id' => $stream->getId(),
                ]);
            }
        }
    }
}
