<?php namespace Visiosoft\EvdepismisTheme\Seeds;

use Anomaly\BlocksModule\Area\Contract\AreaRepositoryInterface;
use Anomaly\BlocksModule\Block\Contract\BlockRepositoryInterface;
use Anomaly\BlocksModule\Type\Contract\TypeRepositoryInterface;
use Anomaly\Streams\Platform\Assignment\Contract\AssignmentRepositoryInterface;
use Anomaly\Streams\Platform\Field\Contract\FieldRepositoryInterface;
use Anomaly\Streams\Platform\Model\Blocks\BlocksDiscountBannerBlocksEntryModel;
use Anomaly\Streams\Platform\Stream\Contract\StreamRepositoryInterface;
use Illuminate\Database\Seeder;
use Visiosoft\CustomfieldsModule\Cfvalue\Contract\CfvalueRepositoryInterface;
use Visiosoft\CustomfieldsModule\CustomField\Contract\CustomFieldRepositoryInterface;

class DiscountSeeder extends Seeder
{
    private $areaRepository;
    private $blocksTypeRepository;
    private $fieldRepository;
    private $streamRepository;
    private $blockRepository;
    private $assignmentRepository;

    public function __construct(
        AreaRepositoryInterface       $areaRepository,
        TypeRepositoryInterface       $blocksTypeRepository,
        FieldRepositoryInterface      $fieldRepository,
        StreamRepositoryInterface     $streamRepository,
        BlockRepositoryInterface      $blockRepository,
        AssignmentRepositoryInterface $assignmentRepository
    )
    {
        $this->areaRepository = $areaRepository;
        $this->blocksTypeRepository = $blocksTypeRepository;
        $this->fieldRepository = $fieldRepository;
        $this->streamRepository = $streamRepository;
        $this->blockRepository = $blockRepository;
        $this->assignmentRepository = $assignmentRepository;
    }

    public function run()
    {
        // Check area
        if (!$area = $this->areaRepository->findBySlug('discount-at-store')) {
            $area = $this->areaRepository->create([
                'name' => 'Discount At Store',
                'slug' => 'discount-at-store',
            ]);
        }

        // Check type
        if (!$blockType = $this->blocksTypeRepository->findBySlug('discount_banner')) {
            $blockType = $this->blocksTypeRepository->create([
                'category' => 'content',
                'name' => 'Discount Banner',
                'slug' => 'discount_banner',
                'wrapper_layout' => '{% extends "anomaly.module.blocks::types.wrapper" %}',
            ]);
        }

        // Check stream
        if (!$stream = $this->streamRepository->findBySlugAndNamespace('discount_banner_blocks', 'blocks')) {
            return;
        }

        $blockFields = [
            [
                'name' => 'Image',
                'slug' => 'image',
                'namespace' => 'blocks',
                'type' => 'anomaly.field_type.file',
                'translatable' => false,
                'config' => [
                    'required' => true,
                    'folders' => ['images'],
                ],
            ], [
                'name' => 'Detail',
                'slug' => 'detail',
                'namespace' => 'blocks',
                'type' => 'anomaly.field_type.wysiwyg',
                'translatable' => true,
                'config' => []
            ]
        ];

        foreach ($blockFields as $blockField) {
            $field = $this->fieldRepository->findBySlugAndNamespace($blockField['slug'], 'blocks');
            if (!$field) {
                $field = $this->fieldRepository->create([
                    'name' => $blockField['name'],
                    'namespace' => $blockField['namespace'],
                    'slug' => $blockField['slug'],
                    'type' => $blockField['type'],
                    'locked' => 0,
                    'config' => $blockField['config'],
                ]);
            }

            $assign = $this->assignmentRepository->findByStreamAndField($stream, $field);
            if (!$assign) {
                $this->assignmentRepository->create([
                    'stream_id' => $stream->getId(),
                    'field_id' => $field->id,
                    'translatable' => $blockField['translatable'],
                ]);
            }

        }

        $blockFieldId = $this->fieldRepository->findBySlugAndNamespace('blocks', 'blocks')->getId();

        $block = $this->blockRepository->create([
            'title' => '',
            'field' => $blockFieldId,
            'extension' => 'anomaly.extension.discount_banner_block',
            'display_title' => false
        ]);

        $blockInfo = app(BlocksDiscountBannerBlocksEntryModel::class)->newQuery()->create([
            'detail' => '<div class="offer-bnnr-items">
                            <h1>10% off </h1>
                            <p>on all orders get the code : 156CD85</p>
                        </div>
                        <div class="offer-order">
                            <a href="#" class="offer-btn-1 btn-link" title="Order Now">Order Now </a>
                        </div>',
        ]);


        $block->update([
            'area_id' => $area->getId(),
            'area_type' => get_class($area),
            'entry_id' => $blockInfo->id,
            'entry_type' => get_class($blockInfo),
        ]);

    }
}
