const cityInput = $('#listCityFilter')

$('.meal-filter-location .cities').on('change', 'input', function () {
    const checkedCities = cityInput.val().split(',').filter(city => city.length > 0)

    if (this.checked) {
        checkedCities.push(this.value)
        cityInput.val(checkedCities.join())
    } else {
        cityInput.val(checkedCities.filter(city => city != this.value).join())
    }
    console.log(cityInput.val())
});

function getMealCities(search = null) {
    crudAjax({'id': defaultCountry, 'search': search}, '/ajax/getCities', 'GET', function (callback) {
        cities = callback;
        $('.meal-filter-location .cities').html(``);
        $.each(callback, function (key, val) {
            $('.meal-filter-location .cities')
                .append(`
                    <p>
                        <input type="checkbox" id="city${val.id}" value="${val.id}"
                            ${selected_cities.length && $.inArray(`${val.id}`, selected_cities) >= 0 ? 'checked' : null}>
                        <label for="city${val.id}">${val.name}</label>
                    </p>
                `);
        });
    });
}

$('.search-area-input').on('keyup', function () {
    getMealCities($(this).val());
});

$(() => {
    getMealCities();
})
