<?php namespace Visiosoft\EvdepismisTheme;

use Anomaly\Streams\Platform\Database\Seeder\Seeder;
use Anomaly\NavigationModule\Menu\Contract\MenuRepositoryInterface;
use Anomaly\NavigationModule\Link\Contract\LinkRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;
use Anomaly\UrlLinkTypeExtension\UrlLinkTypeModel;
use Visiosoft\StoreModule\Store\Contract\StoreRepositoryInterface;
use Anomaly\Streams\Platform\Field\Contract\FieldRepositoryInterface;
use Anomaly\Streams\Platform\Stream\Contract\StreamRepositoryInterface;
use Anomaly\Streams\Platform\Assignment\Contract\AssignmentRepositoryInterface;
use Visiosoft\StoreModule\Category\CategoryModel;


class EvdepismisThemeSeeder extends Seeder
{
    protected $menus;
    protected $links;
    protected $streamRepository;
    protected $storeRepository;
    protected $fieldRepository;
    protected $assignmentRepository;

    public function __construct(MenuRepositoryInterface $menus, LinkRepositoryInterface $links, 
    StreamRepositoryInterface $streamRepository, StoreRepositoryInterface $storeRepository, 
    FieldRepositoryInterface $fieldRepository, AssignmentRepositoryInterface $assignmentRepository)
    {
        $this->menus = $menus;
        $this->links = $links;
        $this->streamRepository = $streamRepository;
        $this->storeRepository = $storeRepository;
        $this->fieldRepository = $fieldRepository;
        $this->assignmentRepository = $assignmentRepository;
    }

    public function run()
    {
        $menus = [
            [
                'en' => [
                    'name' => 'Top Menu',
                    'description' => '',
                ],
                'slug' => 'top_menu',
            ],
            [
                'en' => [
                    'name' => 'Main Menu',
                    'description' => '',
                ],
                'slug' => 'main_menu',
            ],
            [
                'en' => [
                    'name' => 'About Us',
                    'description' => '',
                ],
                'slug' => 'about_us',
            ],
            [
                'en' => [
                    'name' => 'Business',
                    'description' => '',
                ],
                'slug' => 'business',
            ],
            [
                'en' => [
                    'name' => 'Partner With Us',
                    'description' => '',
                ],
                'slug' => 'partner_with_us',
            ],
        ];

        $repository = new EntryRepository();
        $repository->setModel(new UrlLinkTypeModel());
        $test = $repository->create(
            [
                'en' => [
                    'title' => 'Deneme',
                ],
                'url' => 'https://openclassify.com/',
            ]
        );

        foreach ($menus as $menu) {
            if (!$this->menus->findBySlug($menu['slug'])) {
                $this->menus->create(
                    $menu
                );
            }

            $menu = $this->menus->findBySlug($menu['slug']);

            $links = [
                [
                    'menu'   => $menu,
                    'target' => 'none',
                    'entry'  => $test,
                    'type'   => 'anomaly.extension.url_link_type',
                ],
                [
                    'menu'   => $menu,
                    'target' => 'none',
                    'entry'  => $test,
                    'type'   => 'anomaly.extension.url_link_type',
                ],
                [
                    'menu'   => $menu,
                    'target' => 'none',
                    'entry'  => $test,
                    'type'   => 'anomaly.extension.url_link_type',
                ],
                [
                    'menu'   => $menu,
                    'target' => 'none',
                    'entry'  => $test,
                    'type'   => 'anomaly.extension.url_link_type',
                ],
                [
                    'menu'   => $menu,
                    'target' => 'none',
                    'entry'  => $test,
                    'type'   => 'anomaly.extension.url_link_type',
                ],
            ];
            
            foreach ($links as $link) {
                $this->links->create(
                    $link
                );
            }
        }
        
        //Create Store Fields
        $store = $this->streamRepository->findBySlugAndNamespace('store', 'store');

        $storeFields = [
            [
                'name_fields' => [
                    'en' => [
                        'name' => 'Working Time',
                    ],
                    'tr' => [
                        'name' => 'Çalışma Zamanı',
                    ],
                ],
                'slug' => 'working_time',
                'namespace' => 'store',
                'translatable' => false,
                'type' => 'visiosoft.field_type.json',
                "config" => [
                    "required" => true,
                ],
            ],
            [
                'name_fields' => [
                    'en' => [
                        'name' => 'Delivery Service',
                    ],
                    'tr' => [
                        'name' => 'Evlere Servis',
                    ],
                ],
                'slug' => 'delivery_service',
                'namespace' => 'store',
                'type' => 'anomaly.field_type.boolean',
                'translatable' => false,
                "config" => [
                    "required" => true,
                    "mode" => "radio",
                    "default_value" => false,
                    "on_text" => "Available",
                    "off_text" => "Not Available",
                ],
            ],
            [
                'name_fields' => [
                    'en' => [
                        'name' => 'Cuisines',
                    ],
                    'tr' => [
                        'name' => 'Mutfaklar',
                    ],
                ],
                'slug' => 'cuisines',
                'namespace' => 'store',
                'type' => 'anomaly.field_type.checkboxes',
                'translatable' => false,
                "config" => [
                    "default_value" => null,
                    "checked"       => [],
                    "disabled"      => [],
                    "separator"     => ":",
                    "options"       => null,
                    "min"           => null,
                    "max"           => null,
                    "mode"          => "checkboxes",
                    "handler"       => "Visiosoft\EvdepismisTheme\Handlers\StoreCategoryOptions@handle"
                ]
            ],
        ];

        foreach ($storeFields as $storeField) {
            $field = $this->fieldRepository->findBySlugAndNamespace($storeField['slug'], 'store');
            if (!$field) {
                $field = $this->fieldRepository->create(array_merge([
                    'namespace' => $storeField['namespace'],
                    'slug' => $storeField['slug'],
                    'type' => $storeField['type'],
                    'locked' => 0,
                    "config" => $storeField['config']
                ],$storeField['name_fields']));
            }

            $assign = $this->assignmentRepository->findByStreamAndField($store, $field);
            if (!$assign) {
                $this->assignmentRepository->create([
                    'stream_id' => $store->getId(),
                    'field_id' => $field->id,
                    'translatable' => $storeField['translatable']
                ]);
            }
        }
    }
}
