<?php namespace Visiosoft\EvdepismisTheme\Seeds;

use Anomaly\BlocksModule\Area\Contract\AreaRepositoryInterface;
use Anomaly\BlocksModule\Type\Contract\TypeRepositoryInterface;
use Anomaly\Streams\Platform\Assignment\Contract\AssignmentRepositoryInterface;
use Anomaly\Streams\Platform\Field\Contract\FieldRepositoryInterface;
use Anomaly\Streams\Platform\Model\Repeater\RepeaterUnderCookingCategoriesEntryModel;
use Anomaly\Streams\Platform\Stream\Contract\StreamRepositoryInterface;
use Illuminate\Database\Seeder;
use Anomaly\BlocksModule\Block\Contract\BlockRepositoryInterface;
use Illuminate\Support\Facades\DB;

class UnderCategoriesSeeder extends Seeder
{
    private $areaRepository;
    private $blocksTypeRepository;
    private $fieldRepository;
    private $streamRepository;
    private $blockRepository;
    private $assignmentRepository;

    public function __construct(
        AreaRepositoryInterface $areaRepository,
        TypeRepositoryInterface $blocksTypeRepository,
        FieldRepositoryInterface $fieldRepository,
        StreamRepositoryInterface $streamRepository,
        BlockRepositoryInterface $blockRepository,
        AssignmentRepositoryInterface $assignmentRepository
    ) {
        $this->areaRepository = $areaRepository;
        $this->blocksTypeRepository = $blocksTypeRepository;
        $this->fieldRepository = $fieldRepository;
        $this->streamRepository = $streamRepository;
        $this->blockRepository = $blockRepository;
        $this->assignmentRepository = $assignmentRepository;
    }

    public function run()
    {
        // Check area
        if (!$area = $this->areaRepository->findBySlug('cooked-at-home')) {
            $area = $this->areaRepository->create([
                'name' => 'Cooked at Home',
                'slug' => 'cooked-at-home',
            ]);
        }

        // Check type
        if (!$blockType = $this->blocksTypeRepository->findBySlug('under_categories')) {
            $blockType = $this->blocksTypeRepository->create([
                'category' => 'content',
                'name' => 'Under Categories',
                'slug' => 'under_categories',
                'content_layout' => '
                    {% for item in block.under_cooking_categories %}
                        <div class="col-md-4 col-sm-12 col-xs-12">
                            <div class="work-item">
                                <div class="work-img">
                                    <img src="{{ item.image ? item.image.make.url : img(\'visiosoft.theme.base::images/no-image.png\').url }}">
                                </div>
                                <div class="work-text">
                                    <h4>{{ item.title }}</h4>
                                    <p>{{ item.description }}</p>
                                </div>
                            </div>
                        </div>
                    {% endfor %}
                ',
                'wrapper_layout' => '{% extends "anomaly.module.blocks::types.wrapper" %}',
            ]);
        }

        // Check stream
        if (!$stream = $this->streamRepository->findBySlugAndNamespace('under_categories_blocks', 'blocks')) {
            return;
        }

        // Check fields
        if (!$repeater = $this->streamRepository->findBySlugAndNamespace('under_cooking_categories', 'repeater')) {
            $repeater = $this->streamRepository->create([
                'name' => 'Under cooking categories',
                'namespace' => 'repeater',
                'slug' => 'under_cooking_categories',
                'prefix' => 'repeater_',
                'translatable' => true
            ]);
        }

        $repeaterFields = [
            'image' => [
                'name' => 'Image',
                'namespace' => 'repeater',
                'slug' => 'image',
                'type' => 'anomaly.field_type.file',
                "config" => [
                    "folders" => 'images',
                ],
                "assignment_config" => [
                    "required" => true,
                ],
            ],
            'title' => [
                'name' => 'Title',
                'namespace' => 'repeater',
                'slug' => 'title',
                'type' => 'anomaly.field_type.text',
                "assignment_config" => [
                    "required" => true,
                    "translatable" => true,
                ],
            ],
            'description' => [
                'name' => 'Description',
                'namespace' => 'repeater',
                'slug' => 'description',
                'type' => 'anomaly.field_type.text',
                "assignment_config" => [
                    "required" => true,
                    "translatable" => true,
                ],
            ]
        ];

        foreach ($repeaterFields as $repeaterField) {
            if (!$field = $this->fieldRepository->findBySlugAndNamespace($repeaterField['slug'], $repeaterField['namespace'])) {
                $field = $this->fieldRepository->create([
                    'name' => $repeaterField['name'],
                    'namespace' => $repeaterField['namespace'],
                    'slug' => $repeaterField['slug'],
                    'type' => $repeaterField['type'],
                    'locked' => 0,
                    "config" => $repeaterField['config'] ?? null
                ]);
            }

            if (!$this->assignmentRepository->findByStreamAndField($repeater, $field)) {
                $this->assignmentRepository->create([
                    'stream_id' => $repeater->getId(),
                    'field_id' => $field->id,
                    'label' => $repeaterField['name'],
                    'config' => $repeaterField['assignment_config'] ?? null
                ]);
            }
        }

        $blocksFields = [
            'under_cooking_categories' => [
                'name' => 'Under cooking categories',
                'namespace' => 'blocks',
                'slug' => 'under_cooking_categories',
                'type' => 'anomaly.field_type.repeater',
                "config" => [
                    "related" => RepeaterUnderCookingCategoriesEntryModel::class,
                    "max" => 3,
                ]
            ]
        ];

        foreach ($blocksFields as $blocksField) {
            $field = $this->fieldRepository->findBySlugAndNamespace($blocksField['slug'], $blocksField['namespace']);
            if (!$field) {
                $field = $this->fieldRepository->create([
                    'name' => $blocksField['name'],
                    'namespace' => $blocksField['namespace'],
                    'slug' => $blocksField['slug'],
                    'type' => $blocksField['type'],
                    'locked' => 0,
                    "config" => $blocksField['config'] ?? null
                ]);
            }

            if (!$this->assignmentRepository->findByStreamAndField($stream, $field)) {
                $this->assignmentRepository->create([
                    'stream_id' => $stream->getId(),
                    'field_id' => $field->id,
                    'label' => $blocksField['name'],
                ]);
            }
        }

        // Add default values
        $blockFieldId = $this->fieldRepository->findBySlugAndNamespace('blocks', 'blocks')->getId();
        if (!$block = $this->blockRepository->findBy('extension', 'anomaly.extension.under_categories_block')) {
            $block = $this->blockRepository->create([
                'field' => $blockFieldId,
                'extension' => 'anomaly.extension.under_categories_block',
                'display_title' => false,
            ]);
        }
        if (!$repeaterInfo = app(RepeaterUnderCookingCategoriesEntryModel::class)->first()) {
            $repeaterInfo = app(RepeaterUnderCookingCategoriesEntryModel::class)->create([
                'description' => 'Test desc',
                'title' => 'Test title',
            ]);
        }
        if (!$model = app('Anomaly\Streams\Platform\Model\Blocks\BlocksUnderCategoriesBlocksEntryModel')->first()) {
            $model = app('Anomaly\Streams\Platform\Model\Blocks\BlocksUnderCategoriesBlocksEntryModel')->create();
        }
        if (!DB::table('blocks_under_categories_blocks_under_cooking_categories')->where([
            'related_id' => $repeaterInfo->id,
            'entry_id' => $model->id,
        ])->first()) {
            DB::table('blocks_under_categories_blocks_under_cooking_categories')->insert([
                'related_id' => $repeaterInfo->id,
                'entry_id' => $model->id,
            ]);
        }
        $block->update([
            'area_id' => $area->getId(),
            'area_type' => get_class($area),
            'entry_id' => $model->id,
            'entry_type' => get_class($model),
        ]);
    }
}
