<?php namespace Visiosoft\EvdepismisTheme\Listeners;

use Anomaly\Streams\Platform\Ui\Form\Event\FormWasPosted;
use Illuminate\Database\Eloquent\Builder;
use Visiosoft\StoreModule\Store\Form\StoreFormBuilder;
use Anomaly\UsersModule\User\Contract\UserRepositoryInterface;
use Illuminate\Support\Facades\Auth;

class SaveIdentificationNumber
{
    private $userRepository;

    public function __construct(UserRepositoryInterface $userRepository)
    {
        $this->userRepository = $userRepository;
    }

    public function handle(FormWasPosted $event)
    {
        $builder = $event->getBuilder();

        if (get_class($builder) == StoreFormBuilder::class) {

            $identification_number = $builder->getFormField('tax_number')->getValue();

            $relatedUser = $this->userRepository->find(Auth::id());
    
            $relatedUser->update([
                'identification_number' => $identification_number,
            ]);
            
        } else {
            return;
        }
    }
}
