<?php namespace Visiosoft\EvdepismisTheme;

use Anomaly\Streams\Platform\Addon\Plugin\Plugin;
use Visiosoft\CommentsModule\Comment\Contract\CommentRepositoryInterface;

class EvdepismisThemePlugin extends Plugin
{
    public function getFunctions()
    {
        return [
            new \Twig_SimpleFunction(
                'ep_calc_rating',
                function ($entryType, $entryID) {
                    $rating = app(CommentRepositoryInterface::class)->getRating($entryType, $entryID);
                    $trueStars = ceil($rating['rating'] / 100 * 5);

                    $stars = '';
                    if ($trueStars) {
                        for ($i = 1; $i <= $trueStars; $i++) {
                            $stars .= '<i class="fas fa-star"></i>';
                        }
                    }

                    if (5 - $trueStars > 0) {
                        for ($i = 1; $i <= 5 - $trueStars; $i++) {
                            $stars .= '<i class="far fa-star"></i>';
                        }
                    }

                    $stars .= "<span>" . $rating['count'] . "</span>";

                    return $stars;
                }
            ),
        ];
    }
}
