$(document).ready(function () {
  $("input[type='radio']").attr("checked", false);

  $("input[name='working_time']").hide();

  $("#days input[type='checkbox']").change(function () {
    if ($("#days input:checkbox:checked").length > 1) {
      if ($("#day_by_day_table:visible").length > 0) {
        createDayByDayTable();
      }

      $("#time_setting_rule_container").show();
    } else {
      $("#time_setting_rule_container").hide();
    }
  });

  $("#day_by_day_time").change(function () {
    $("#day_by_day_table").toggle();

    createDayByDayTable();

    $("#single_time_selecter").toggle();
  });

  function createDayByDayTable() {
    $("#dynamic_day_times").empty();

    let selectedDays = $("#days input:checkbox:checked");

    $.each(selectedDays, function (index, dayInput) {
      let selectedDayName = dayInput.nextElementSibling.title;
      let selectedDayId = dayInput.id;

      $("#dynamic_day_times").append(
        `
          <tr>
            <td>${selectedDayName}</td>
            <td>
              <div class="form-group">
                <div class="dropdown bootstrap-select">
                  <select class="selectpicker" tabindex="-98" id="${selectedDayId}_from_time">
                    <option value="00:00">00:00</option>
                    <option value="01:00">01:00</option>
                    <option value="02:00">02:00</option>
                    <option value="03:00">03:00</option>
                    <option value="04:00">04:00</option>
                    <option value="05:00">05:00</option>
                    <option value="06:00">06:00</option>
                    <option value="07:00">07:00</option>
                    <option value="08:00">08:00</option>
                    <option value="09:00">09:00</option>
                    <option value="10:00">10:00</option>
                    <option value="11:00">11:00</option>
                    <option value="12:00">12:00</option>
                    <option value="13:00">13:00</option>
                    <option value="14:00">14:00</option>
                    <option value="15:00">15:00</option>
                    <option value="16:00">16:00</option>
                    <option value="17:00">17:00</option>
                    <option value="18:00">18:00</option>
                    <option value="19:00">19:00</option>
                    <option value="20:00">20:00</option>
                    <option value="21:00">21:00</option>
                    <option value="22:00">22:00</option>
                    <option value="23:00">23:00</option>
                  </select>
                </div>
              </div>
            </td>
            <td>
              <div class="form-group">
                <div class="dropdown bootstrap-select">
                  <select class="selectpicker" tabindex="-98" id="${selectedDayId}_to_time">
                  <option value="00:00">00:00</option>
                  <option value="01:00">01:00</option>
                  <option value="02:00">02:00</option>
                  <option value="03:00">03:00</option>
                  <option value="04:00">04:00</option>
                  <option value="05:00">05:00</option>
                  <option value="06:00">06:00</option>
                  <option value="07:00">07:00</option>
                  <option value="08:00">08:00</option>
                  <option value="09:00">09:00</option>
                  <option value="10:00">10:00</option>
                  <option value="11:00">11:00</option>
                  <option value="12:00">12:00</option>
                  <option value="13:00">13:00</option>
                  <option value="14:00">14:00</option>
                  <option value="15:00">15:00</option>
                  <option value="16:00">16:00</option>
                  <option value="17:00">17:00</option>
                  <option value="18:00">18:00</option>
                  <option value="19:00">19:00</option>
                  <option value="20:00">20:00</option>
                  <option value="21:00">21:00</option>
                  <option value="22:00">22:00</option>
                  <option value="23:00">23:00</option>
                  </select>
                </div>
              </div>
            </td>
        </tr>
      `
      );
    });

    $("select").selectpicker();
  }

  $("#submit_button").click(function () {
    let engagement = new Object();
    let selectedDays = $("#days input:checkbox:checked");

    if ($("#day_by_day_time").is(":checked")) {
      $.each(selectedDays, function (index, dayInput) {
        let fromTime = $("#" + dayInput.id + "_from_time").val();
        let toTime = $("#" + dayInput.id + "_to_time").val();

        engagement[dayInput.id] = [fromTime, toTime];
      });
    } else {
      let fromTime = $("#all_days_fromTime").val();
      let toTime = $("#all_days_toTime").val();
      $.each(selectedDays, function (index, dayInput) {
        engagement[dayInput.id] = [fromTime, toTime];
      });
    }

    $("input[name='working_time']").val(JSON.stringify(engagement));
  });
});
