<?php namespace Visiosoft\EvdepismisTheme\Listeners;

use Anomaly\Streams\Platform\Ui\Form\Event\FormWasSaved;
use Illuminate\Database\Eloquent\Builder;
use Visiosoft\StoreModule\Store\Form\StoreFormBuilder;
use Visiosoft\StoreModule\Store\Contract\StoreRepositoryInterface;

class DeleteCarrierFieldData
{
    private $storeRepository;

    public function __construct(StoreRepositoryInterface $storeRepository)
    {
        $this->storeRepository = $storeRepository;
    }

    public function handle(FormWasSaved $event)
    {
        $builder = $event->getBuilder();

        if (get_class($builder) == StoreFormBuilder::class) {

            if ($builder->getFormField('slug')) {
                $relatedStore = $this->storeRepository->findBy('slug', $builder->getFormField('slug')->getValue());

                $relatedStore->update([
                    'tax_number' => null,
                ]);
            }

        } else {
            return;
        }
    }
}
