<?php namespace Visiosoft\EvdepismisTheme\Seeds;

use Anomaly\NavigationModule\Link\Contract\LinkRepositoryInterface;
use Anomaly\NavigationModule\Menu\Contract\MenuRepositoryInterface;
use Anomaly\Streams\Platform\Model\UrlLinkType\UrlLinkTypeUrlsEntryModel;
use Illuminate\Database\Seeder;

class FooterMenuSeeder extends Seeder
{
    private $menuRepository;
    private $linkTypeUrlsEntryModel;
    private $linkRepository;

    public function __construct(
        MenuRepositoryInterface $menuRepository,
        UrlLinkTypeUrlsEntryModel $linkTypeUrlsEntryModel,
        LinkRepositoryInterface $linkRepository
    ) {
        $this->menuRepository = $menuRepository;
        $this->linkTypeUrlsEntryModel = $linkTypeUrlsEntryModel;
        $this->linkRepository = $linkRepository;
    }

    public function run()
    {
        $footerMenus = [
            [
                'name' => 'Footer 1',
                'slug' => 'footer_1',
            ],
            [
                'name' => 'Footer 2',
                'slug' => 'footer_2',
            ],
            [
                'name' => 'Footer 3',
                'slug' => 'footer_3',
            ],
        ];

        foreach ($footerMenus as $footerMenu) {
            if (!$menu = $this->menuRepository->findBySlug($footerMenu['slug'])) {
                $menu = $this->menuRepository->create($footerMenu);
            }

            if (!count($menu->getLinks())) {
                $url = $this->linkTypeUrlsEntryModel->create([
                    'title' => $footerMenu['name'] . ' link',
                    'url' => '#',
                ]);

                $this->linkRepository->create([
                    'menu' => $menu->id,
                    'type' => 'anomaly.extension.url_link_type',
                    'entry' => $url,
                    'target' => '_self',
                ]);
            }
        }
    }
}
