<?php namespace Visiosoft\EvdepismisTheme;

use Anomaly\BlocksModule\Area\AreaRepository;
use Anomaly\BlocksModule\Type\Contract\TypeRepositoryInterface;
use Anomaly\Streams\Platform\Database\Seeder\Seeder;
use Anomaly\NavigationModule\Menu\Contract\MenuRepositoryInterface;
use Anomaly\NavigationModule\Link\Contract\LinkRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;
use Anomaly\UrlLinkTypeExtension\UrlLinkTypeModel;
use Visiosoft\AdvsModule\Adv\AdvModel;
use Visiosoft\EvdepismisTheme\Seeds\CreateInstructionSeeder;
use Visiosoft\EvdepismisTheme\Seeds\CustomFieldsSeeder;
use Visiosoft\EvdepismisTheme\Seeds\FooterMenuSeeder;
use Visiosoft\EvdepismisTheme\Seeds\StoreFieldsSeeder;
use Visiosoft\EvdepismisTheme\Seeds\DiscountSeeder;
use Visiosoft\EvdepismisTheme\Seeds\UnderCategoriesSeeder;
use Visiosoft\StoreModule\Store\Contract\StoreRepositoryInterface;
use Anomaly\Streams\Platform\Field\Contract\FieldRepositoryInterface;
use Anomaly\Streams\Platform\Stream\Contract\StreamRepositoryInterface;
use Anomaly\Streams\Platform\Assignment\Contract\AssignmentRepositoryInterface;

class EvdepismisThemeSeeder extends Seeder
{
    protected $menus;
    protected $links;
    protected $storeRepository;
    protected $fieldRepository;
    protected $assignmentRepository;
    protected $areas;
    protected $streamRepository;
    protected $typeRepository;
    protected $advModel;

    public function __construct(
        MenuRepositoryInterface $menus,
        LinkRepositoryInterface $links,
        StoreRepositoryInterface $storeRepository,
        AssignmentRepositoryInterface $assignmentRepository,
        AreaRepository $areas,
        AdvModel $advModel,
        TypeRepositoryInterface $typeRepository,
        FieldRepositoryInterface $fieldRepository,
        StreamRepositoryInterface $streamRepository)
    {
        $this->menus = $menus;
        $this->links = $links;
        $this->storeRepository = $storeRepository;
        $this->fieldRepository = $fieldRepository;
        $this->areas = $areas;
        $this->assignmentRepository = $assignmentRepository;
        $this->streamRepository = $streamRepository;
        $this->typeRepository = $typeRepository;
        $this->advModel = $advModel;
    }

    public function run()
    {
        $this->call(UnderCategoriesSeeder::class);

        $this->call(CustomFieldsSeeder::class);

        $this->call(DiscountSeeder::class);

        $this->call(FooterMenuSeeder::class);

        $this->call(StoreFieldsSeeder::class);

        $this->call(CreateInstructionSeeder::class);

//        /**
//         * Create Menus
//         * Author Vedat Akdoğan
//         * Visiosoft LTD.
//         */
//        $menus = [
//            [
//                'en' => [
//                    'name' => 'Top Menu',
//                    'description' => '',
//                ],
//                'slug' => 'top_menu',
//            ],
//            [
//                'en' => [
//                    'name' => 'About Us',
//                    'description' => '',
//                ],
//                'slug' => 'about_us',
//            ],
//            [
//                'en' => [
//                    'name' => 'Business',
//                    'description' => '',
//                ],
//                'slug' => 'business',
//            ],
//            [
//                'en' => [
//                    'name' => 'Partner With Us',
//                    'description' => '',
//                ],
//                'slug' => 'partner_with_us',
//            ],
//        ];
//
//
//        foreach ($menus as $menu) {
//            if (!$this->menus->findBySlug($menu['slug'])) {
//                $this->menus->create(
//                    $menu
//                );
//            }
//        }
//
//        /**
//         * Create Links
//         * Author Vedat Akdoğan
//         * Visiosoft LTD.
//         */
//
//        $repository = new EntryRepository();
//        $repository->setModel(new UrlLinkTypeModel());
//
//        $openclassify = $repository->create([
//            'en' => [
//                'title' => 'Openclassify.com',
//            ],
//            'url' => 'https://openclassify.com/',
//        ]);
//
//        $visiosoft = $repository->create([
//            'en' => [
//                'title' => 'Visiosoft LTD',
//            ],
//            'url' => 'https://visiosoft.com.tr/',
//        ]);
//
//
//        foreach ($menus as $menu) {
//
//            $menu = $this->menus->findBySlug($menu['slug']);
//
//            $links = [
//                [
//                    'menu' => $menu,
//                    'target' => 'none',
//                    'entry' => $openclassify,
//                    'type' => 'anomaly.extension.url_link_type',
//                ],
//                [
//                    'menu' => $menu,
//                    'target' => 'none',
//                    'entry' => $visiosoft,
//                    'type' => 'anomaly.extension.url_link_type',
//                ],
//            ];
//
//            foreach ($links as $link) {
//                $this->links->create(
//                    $link
//                );
//            }
//        }
////
////        //Create Store Fields
////        $store = $this->streamRepository->findBySlugAndNamespace('store', 'store');
////
////        $storeFields = [
////            [
////                'name_fields' => [
////                    'en' => [
////                        'name' => 'Working Time',
////                    ],
////                    'tr' => [
////                        'name' => 'Çalışma Zamanı',
////                    ],
////                ],
////                'slug' => 'working_time',
////                'namespace' => 'store',
////                'translatable' => false,
////                'type' => 'visiosoft.field_type.json',
////                "config" => [
////                    "required" => true,
////                ],
////            ],
////            [
////                'name_fields' => [
////                    'en' => [
////                        'name' => 'Delivery Service',
////                    ],
////                    'tr' => [
////                        'name' => 'Evlere Servis',
////                    ],
////                ],
////                'slug' => 'delivery_service',
////                'namespace' => 'store',
////                'type' => 'anomaly.field_type.boolean',
////                'translatable' => false,
////                "config" => [
////                    "required" => true,
////                    "mode" => "radio",
////                    "default_value" => false,
////                    "on_text" => "Available",
////                    "off_text" => "Not Available",
////                ],
////            ],
////            [
////                'name_fields' => [
////                    'en' => [
////                        'name' => 'Cuisines',
////                    ],
////                    'tr' => [
////                        'name' => 'Mutfaklar',
////                    ],
////                ],
////                'slug' => 'cuisines',
////                'namespace' => 'store',
////                'type' => 'anomaly.field_type.checkboxes',
////                'translatable' => false,
////                "config" => [
////                    "default_value" => null,
////                    "checked" => [],
////                    "disabled" => [],
////                    "separator" => ":",
////                    "options" => null,
////                    "min" => null,
////                    "max" => null,
////                    "mode" => "checkboxes",
////                    "handler" => "Visiosoft\EvdepismisTheme\Handlers\StoreCategoryOptions@handle"
////                ]
////            ],
////        ];
////
////        foreach ($storeFields as $storeField) {
////            $field = $this->fieldRepository->findBySlugAndNamespace($storeField['slug'], 'store');
////            if (!$field) {
////                $field = $this->fieldRepository->create(array_merge([
////                    'namespace' => $storeField['namespace'],
////                    'slug' => $storeField['slug'],
////                    'type' => $storeField['type'],
////                    'locked' => 0,
////                    "config" => $storeField['config']
////                ], $storeField['name_fields']));
////            }
////
////            $assign = $this->assignmentRepository->findByStreamAndField($store, $field);
////            if (!$assign) {
////                $this->assignmentRepository->create([
////                    'stream_id' => $store->getId(),
////                    'field_id' => $field->id,
////                    'translatable' => $storeField['translatable']
////                ]);
////            }
////        }
//
//        /**
//         * Create Blocks
//         * Author Vedat Akdoğan
//         * Visiosoft LTD.
//         */
//        $areas = [
//            [
//                'en' => [
//                    'name' => 'Bottom Area',
//                    'description' => 'For the Evdepismis theme, the bottom ad space.',
//                ],
//                'tr' => [
//                    'name' => 'Alt Reklam Alanı',
//                    'description' => 'Evdepismis teması için alt reklam alanını temsil eder.',
//                ],
//                'slug' => 'evdepismis-bottom',
//            ],
//            [
//            'en' => [
//                'name' => 'Footer Area',
//                'description' => 'For the Evdepismis theme, the footer ad space.',
//            ],
//            'tr' => [
//                'name' => 'Footer Reklam Alanı',
//                'description' => 'Evdepismis teması için footer reklam alanını temsil eder.',
//            ],
//            'slug' => 'evdepismis-footer',
//        ]
//        ];
//
//
//        //Create Areas
//
//        foreach ($areas as $area) {
//            if (!$this->areas->findBySlug($area['slug'])) {
//                $this->areas->create(
//                    $area
//                );
//            }
//        }
//
//        //Create Block Type
//        $types = [
//            [
//                'name_fields' => [
//                    'en' => [
//                        'name' => 'Advertising Image',
//                    ],
//                    'tr' => [
//                        'name' => 'Reklam Görseli',
//                    ],
//                ],
//                'slug' => 'advertising_image',
//            ]
//        ];
//
//        foreach ($types as $type) {
//            $exists_type = $this->typeRepository->findBySlug($type['slug']);
//            if (!$exists_type) {
//                $this->typeRepository->create(array_merge([
//                    'category' => 'other',
//                    'slug' => $type['slug'],
//                ], $type['name_fields']));
//            }
//        }
//
//        //Create Blocks Fields
//        $typesStream = $this->streamRepository->findBySlugAndNamespace('advertising_image_blocks', 'blocks');
//
//        $blocksFields = [
//            [
//                'name_fields' => [
//                    'en' => [
//                        'name' => 'Advertising Image',
//                    ],
//                    'tr' => [
//                        'name' => 'Reklam Görseli',
//                    ],
//                ],
//                'slug' => 'advertising_image',
//                'namespace' => 'blocks',
//                'translatable' => false,
//                'type' => 'anomaly.field_type.file',
//                "config" => [
//                    "required" => true,
//                    "folders" => ['images'],
//                ],
//            ],
//            [
//                'name_fields' => [
//                    'en' => [
//                        'name' => 'Advertising Image URL',
//                    ],
//                    'tr' => [
//                        'name' => 'Reklam Görseli URL',
//                    ],
//                ],
//                'slug' => 'advertising_image_url',
//                'namespace' => 'blocks',
//                'type' => 'anomaly.field_type.text',
//                'translatable' => false,
//                "config" => [
//                    "required" => true,
//                    "default_value" => "#",
//                ],
//            ],
//
//        ];
//
//        foreach ($blocksFields as $blocksField) {
//            $field = $this->fieldRepository->findBySlugAndNamespace($blocksField['slug'], 'blocks');
//            if (!$field) {
//                $field = $this->fieldRepository->create(array_merge([
//                    'namespace' => $blocksField['namespace'],
//                    'slug' => $blocksField['slug'],
//                    'type' => $blocksField['type'],
//                    'locked' => 0,
//                    "config" => $blocksField['config']
//                ], $blocksField['name_fields']));
//            }
//
//            $assign = $this->assignmentRepository->findByStreamAndField($typesStream, $field);
//            if (!$assign) {
//                $this->assignmentRepository->create([
//                    'stream_id' => $typesStream->getId(),
//                    'field_id' => $field->id,
//                    'translatable' => $blocksField['translatable']
//                ]);
//            }
//        }
    }
}
