$(function () {
  $('.datepicker').datepicker();
});

function getCities(search = null) {
  crudAjax({'id': defaultCountry, 'search': search}, '/ajax/getCities', 'GET', function (callback) {
    cities = callback;
    $('.filter-location-body .cities').html(``);
    $.each(callback, function (key, val) {
      $('.filter-location-body .cities')
          .append(`<p><input type="checkbox" id="${val.id}" name="city[]" value="${val.id}" ${$.inArray(`${val.id}`, selected_cities) >= 0 ? 'checked' : null}><label for="${val.id}">${val.name}</label></p>`);
    });
  });
}

$('.search-area-input').on('keyup', function () {
  getCities($(this).val());
});

$(() => {
  getCities();
})

$('#mapIndexForm').submit(function () {
  if ($('[name=keyword]').val()) {
    $(this).attr('action', '/store/list')
  }
})

$('input[name="rating"]').on('click', function () {
  $('input[name="rating"]').prop('checked', false);
  $(this).prop('checked', true)
});

$('.book-table').on('submit', function (e) {
  e.preventDefault();

  crudAjax($(this).serialize(), '/api/ep/book-table', 'POST', function (callback) {
    $('.book-table').trigger('reset');
    Swal.fire({
      icon: 'success',
      showConfirmButton: false,
      timer: 1500
    })
  })
})

$('.toggle-bookmark').on('click', function () {
    crudAjax({id: $(this).data('id'), type: $(this).data('type')}, '/api/ep/toggle-bookmark', 'POST', function (callback) {
        $('.toggle-bookmark').find('i').toggleClass('far fa');
        Swal.fire({
            icon: 'success',
            showConfirmButton: false,
            timer: 1500,
            toast: true,
            position: 'top-end',
        })
    })
})

$(()=>{
    let toggleBookmark = $('.toggle-bookmark');
    if (toggleBookmark.length){
        crudAjax({}, '/api/ep/check-bookmark/' + toggleBookmark.data('id') + '/' + toggleBookmark.data('type'), 'POST', function (callback) {
            if (callback) {
                $('.toggle-bookmark').find('i').toggleClass('far fa');
            }
        })
    }
})
