<?php namespace Visiosoft\EvdepismisTheme\Seeds;

use Illuminate\Database\Seeder;
use Visiosoft\CustomfieldsModule\Cfvalue\Contract\CfvalueRepositoryInterface;
use Visiosoft\CustomfieldsModule\CustomField\Contract\CustomFieldRepositoryInterface;

class CustomFieldsSeeder extends Seeder
{
    private $customFieldRepository;
    private $cfvalueRepository;

    public function __construct(
        CustomFieldRepositoryInterface $customFieldRepository,
        CfvalueRepositoryInterface $cfvalueRepository
    ) {
        $this->customFieldRepository = $customFieldRepository;
        $this->cfvalueRepository = $cfvalueRepository;
    }

    public function run()
    {
        $fields = [
            [
                'type' => 'select',
                'name' => 'Cuisine',
                'slug' => 'cuisine',
            ],
        ];

        foreach ($fields as $field) {
            if (!$cF = $this->customFieldRepository->findBySlug($field['slug'])) {
                $cF = $this->customFieldRepository->create($field);
            }

            if (!$this->cfvalueRepository->findBy('custom_field_id', $cF->id)) {
                $values = [
                    'Pizza',
                    'Sushi',
                    'Shawarma',
                    'Fish',
                    'Lunch',
                    'Chinese',
                ];
                foreach ($values as $value) {
                    $this->cfvalueRepository->create([
                        'custom_field_id' => $cF->id,
                        'custom_field_value' => $value,
                    ]);
                }
            }
        }
    }
}
