$(function () {
  $('.datepicker').datepicker();
});

// Javascript to enable link to tab
if (location.hash) {
  $('a[href=\'' + location.hash + '\']').tab('show');
}
var activeTab = localStorage.getItem('activeTab');
if (activeTab) {
  $('a[href="' + activeTab + '"]').tab('show');
}

$('body').on('click', 'a[data-toggle=\'tab\']', function (e) {
  e.preventDefault()
  var tab_name = this.getAttribute('href')
  if (history.pushState) {
    history.pushState(null, null, tab_name)
  }
  else {
    location.hash = tab_name
  }
  localStorage.setItem('activeTab', tab_name)

  $(this).tab('show');
  return false;
});
$(window).on('popstate', function () {
  var anchor = location.hash ||
    $('a[data-toggle=\'tab\']').first().attr('href');
  $('a[href=\'' + anchor + '\']').tab('show');
});

// See All

function myFunction() {
  var dots = document.getElementById("dots");
  var moreText = document.getElementById("more");
  var btnText = document.getElementById("readBtn");

  if (dots.style.display === "none") {
    dots.style.display = "inline";
    btnText.innerHTML = "See All";
    moreText.style.display = "none";
  } else {
    dots.style.display = "none";
    btnText.innerHTML = "See Less";
    moreText.style.display = "inline";
  }
}

function getCities(search = null) {
  crudAjax({'id': defaultCountry, 'search': search}, '/ajax/getCities', 'GET', function (callback) {
    cities = callback;
    $('.filter-location-body .cities').html(``);
    $.each(callback, function (key, val) {
      $('.filter-location-body .cities')
          .append(`<p><input type="checkbox" id="${val.id}" name="city[]" value="${val.id}" ${$.inArray(`${val.id}`, selected_cities) >= 0 ? 'checked' : null}><label for="${val.id}">${val.name}</label></p>`);
    });
  });
}

$('.search-area-input').on('keyup', function () {
  getCities($(this).val());
});

$(() => {
  getCities();
})

$('#mapIndexForm').submit(function () {
  if ($('[name=keyword]').val()) {
    $(this).attr('action', '/store/list')
  }
})

$('input[name="rating"]').on('click', function () {
  $('input[name="rating"]').prop('checked', false);
  $(this).prop('checked', true)
});

$('.book-table').on('submit', function (e) {
  e.preventDefault();

  crudAjax($(this).serialize(), '/api/ep/book-table', 'POST', function (callback) {
    $(this).trigger('reset');
  })
})
