<?php namespace Visiosoft\EvdepismisTheme\Seeds;

use Anomaly\BlocksModule\Area\Contract\AreaRepositoryInterface;
use Anomaly\BlocksModule\Type\Contract\TypeRepositoryInterface;
use Anomaly\Streams\Platform\Assignment\Contract\AssignmentRepositoryInterface;
use Anomaly\Streams\Platform\Field\Contract\FieldRepositoryInterface;
use Anomaly\Streams\Platform\Model\Repeater\RepeaterStoreCreateHowItWorksEntryModel;
use Anomaly\Streams\Platform\Stream\Contract\StreamRepositoryInterface;
use Illuminate\Database\Seeder;
use Anomaly\BlocksModule\Block\Contract\BlockRepositoryInterface;
use Illuminate\Support\Facades\DB;

class CreateInstructionSeeder extends Seeder
{
    private $areaRepository;
    private $blocksTypeRepository;
    private $fieldRepository;
    private $streamRepository;
    private $blockRepository;
    private $assignmentRepository;

    public function __construct(
        AreaRepositoryInterface $areaRepository,
        TypeRepositoryInterface $blocksTypeRepository,
        FieldRepositoryInterface $fieldRepository,
        StreamRepositoryInterface $streamRepository,
        BlockRepositoryInterface $blockRepository,
        AssignmentRepositoryInterface $assignmentRepository
    ) {
        $this->areaRepository = $areaRepository;
        $this->blocksTypeRepository = $blocksTypeRepository;
        $this->fieldRepository = $fieldRepository;
        $this->streamRepository = $streamRepository;
        $this->blockRepository = $blockRepository;
        $this->assignmentRepository = $assignmentRepository;
    }

    public function run()
    {
        // Check area
        if (!$area = $this->areaRepository->findBySlug('cooked-at-home')) {
            $area = $this->areaRepository->create([
                'name' => 'Cooked at Home',
                'slug' => 'cooked-at-home',
            ]);
        }

        // Check type
        if (!$blockType = $this->blocksTypeRepository->findBySlug('how_it_works')) {
            $blockType = $this->blocksTypeRepository->create([
                'category' => 'content',
                'name' => 'How It Works',
                'slug' => 'how_it_works',
                'content_layout' => '
                    <div class="new-heading">
                        <h1>How It Works</h1>
                    </div>

                    {% for instruction in block.how_it_works %}
                        <div class="how-it-work-1">
                            <img src="{{ instruction.image ? instruction.image.make.url : img(\'visiosoft.theme.base::images/no-image.png\').url }}">
                            <h4>{{ instruction.title }}</h4>
                            <p>{{ instruction.description }}</p>
                        </div>
                    {% endfor %}
                ',
                'wrapper_layout' => '{% extends "anomaly.module.blocks::types.wrapper" %}',
            ]);
        }

        // Check stream
        if (!$stream = $this->streamRepository->findBySlugAndNamespace('how_it_works_blocks', 'blocks')) {
            return;
        }

        // Check fields
        if (!$repeater = $this->streamRepository->findBySlugAndNamespace('store_create_how_it_works', 'repeater')) {
            $repeater = $this->streamRepository->create([
                'name' => 'Store Create How It Works',
                'namespace' => 'repeater',
                'slug' => 'store_create_how_it_works',
                'prefix' => 'repeater_',
                'translatable' => true
            ]);
        }

        $repeaterFields = [
            [
                'name' => 'Image',
                'slug' => 'image',
                'type' => 'anomaly.field_type.file',
                "config" => [
                    "folders" => 'images',
                ],
                "assignment_config" => [
                    "required" => true,
                ],
            ],
            [
                'name' => 'Title',
                'slug' => 'title',
                'type' => 'anomaly.field_type.text',
                "assignment_config" => [
                    "required" => true,
                    "translatable" => true,
                ],
            ],
            [
                'name' => 'Description',
                'slug' => 'description',
                'type' => 'anomaly.field_type.text',
                "assignment_config" => [
                    "required" => true,
                    "translatable" => true,
                ],
            ]
        ];

        foreach ($repeaterFields as $repeaterField) {
            if (!$field = $this->fieldRepository->findBySlugAndNamespace($repeaterField['slug'], 'repeater')) {
                $field = $this->fieldRepository->create([
                    'name' => $repeaterField['name'],
                    'namespace' => 'repeater',
                    'slug' => $repeaterField['slug'],
                    'type' => $repeaterField['type'],
                    'locked' => 0,
                    "config" => $repeaterField['config'] ?? null
                ]);
            }

            if (!$this->assignmentRepository->findByStreamAndField($repeater, $field)) {
                $this->assignmentRepository->create([
                    'stream_id' => $repeater->getId(),
                    'field_id' => $field->id,
                    'label' => $repeaterField['name'],
                    'config' => $repeaterField['assignment_config'] ?? null
                ]);
            }
        }

        $blocksFields = [
            [
                'name' => 'How It Works',
                'slug' => 'how_it_works',
                'type' => 'anomaly.field_type.repeater',
                "config" => [
                    "related" => RepeaterStoreCreateHowItWorksEntryModel::class,
                    "max" => 3,
                ]
            ]
        ];

        foreach ($blocksFields as $blocksField) {
            $field = $this->fieldRepository->findBySlugAndNamespace($blocksField['slug'], 'blocks');
            if (!$field) {
                $field = $this->fieldRepository->create([
                    'name' => $blocksField['name'],
                    'namespace' => 'blocks',
                    'slug' => $blocksField['slug'],
                    'type' => $blocksField['type'],
                    'locked' => 0,
                    "config" => $blocksField['config'] ?? null
                ]);
            }

            if (!$this->assignmentRepository->findByStreamAndField($stream, $field)) {
                $this->assignmentRepository->create([
                    'stream_id' => $stream->getId(),
                    'field_id' => $field->id,
                    'label' => $blocksField['name'],
                ]);
            }
        }

        // Add default values
        $blockFieldId = $this->fieldRepository->findBySlugAndNamespace('blocks', 'blocks')->getId();
        if (!$block = $this->blockRepository->findBy('extension', 'anomaly.extension.how_it_works_block')) {
            $block = $this->blockRepository->create([
                'field' => $blockFieldId,
                'extension' => 'anomaly.extension.how_it_works_block',
                'display_title' => false,
            ]);
        }
        if (!$repeaterInfo = app(RepeaterStoreCreateHowItWorksEntryModel::class)->first()) {
            $repeaterInfo = app(RepeaterStoreCreateHowItWorksEntryModel::class)->create([
                'description' => 'Test desc',
                'title' => 'Test title',
            ]);
        }
        if (!$model = app('Anomaly\Streams\Platform\Model\Blocks\BlocksHowItWorksBlocksEntryModel')->first()) {
            $model = app('Anomaly\Streams\Platform\Model\Blocks\BlocksHowItWorksBlocksEntryModel')->create();
        }
        if (!DB::table('blocks_how_it_works_blocks_how_it_works')->where([
            'related_id' => $repeaterInfo->id,
            'entry_id' => $model->id,
        ])->first()) {
            DB::table('blocks_how_it_works_blocks_how_it_works')->insert([
                'related_id' => $repeaterInfo->id,
                'entry_id' => $model->id,
            ]);
        }
        $block->update([
            'area_id' => $area->getId(),
            'area_type' => get_class($area),
            'entry_id' => $model->id,
            'entry_type' => get_class($model),
        ]);
    }
}
