<?php namespace Visiosoft\EvdepismisTheme\Handlers;

use Anomaly\CheckboxesFieldType\CheckboxesFieldType;
use Visiosoft\StoreModule\Category\Contract\CategoryRepositoryInterface;

class StoreCategoryOptions
{
    private $categoryRepository;

	public function __construct(CategoryRepositoryInterface $categoryRepository)
	{
		$this->categoryRepository = $categoryRepository;
	}

    public function handle(CheckboxesFieldType $fieldType)
	{
		$storeCategories = $this->categoryRepository->newQuery()->get()->pluck('name', 'id')->all();
		$fieldType->setOptions($storeCategories);
	}
}