<?php namespace Visiosoft\EvdepismisTheme\Notification;

use Anomaly\Streams\Platform\Notification\Message\MailMessage;
use Anomaly\UsersModule\User\Contract\UserInterface;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Notification;


class BookTableMail extends Notification implements ShouldQueue
{
    use Queueable;

    private  $data;

    public function __construct($data)
    {
        $this->data = $data;
    }


    /**
     * @param UserInterface $notifiable
     * @return array
     */
    public function via(UserInterface $notifiable)
    {
        return ["mail"];
    }

    /**
     * @param $data
     * @return MailMessage
     */
    public function toMail()
    {
        return (new MailMessage())
            ->view('visiosoft.theme.evdepismis::notification/book-table', $this->data)
            ->subject(trans('visiosoft.theme.evdepismis::field.booking'))
            ->greeting('greeting')
            ->line('message');
    }
}
