let map, geocoder, infoWindow

function initMap() {
    const options = {
        zoom: 15,
    };
    geocoder = new google.maps.Geocoder();
    map = new google.maps.Map(document.getElementById("map"), options);
    infoWindow = new google.maps.InfoWindow;
    geocodeAddress(geocoder, map, defaultCountry.name)

    google.maps.event.addListener(map, 'idle', function (event) {
        if (map.center) {
            const lat = map.center.lat()
            const lng = map.center.lng()

            crudAjax({lat, lng}, '/api/ep/stores-distance', 'GET', () => {}, true)
                .then(res => {
                    if (res.success) {
                        const stores = res.stores

                        for (let i = 0; i < stores.length; i++) {
                            const store = stores[i]

                            createMarker({lat: Number(store.lat), lng: Number(store.lng)}, `
                                <a href="${storeUrl.replace('slug', store.slug)}"
                                    class="d-flex justify-content-center align-items-center flex-column">
                                    <img src="${store.thumbnail}" width="50px" height="50px">
                                    <span class="mt-2">${store.name}</span>
                                </a>
                            `)
                        }

                        listStores(res.storesHtml)
                    } else {
                        alert(res.msg)
                    }
                })
        }
    });

    $('#searchMapForm').trigger('submit')
}

function listStores(storesHtml) {
    if (storesHtml.length) {
        const storeWrapper = $('.stores-wrapper')
        storeWrapper.empty()

        storeWrapper.append(storesHtml)
    }
}

function geocodeAddress(geocoder, resultsMap, address) {
    geocoder.geocode({ address: address }, (results, status) => {
        if (status === "OK") {
            resultsMap.setCenter(results[0].geometry.location);
            resultsMap.fitBounds(results[0].geometry.viewport)
        }
    });
}

function createMarker(latLng, html) {
    const marker = new google.maps.Marker({
        map,
        position: latLng
    });
    google.maps.event.addListener(marker, 'click', function() {
        infoWindow.setContent(html);
        infoWindow.open(map, marker);
    });
}

$('#searchMapForm').submit(function (e) {
    e.preventDefault()

    const location = $('#searchLocation').val()
    if (location) {
        geocoder.geocode({ address: location }, (results, status) => {
            if (status === "OK") {
                map.setCenter(results[0].geometry.location);
                map.fitBounds(results[0].geometry.viewport)
            }
        });
    }
})
