<?php namespace Visiosoft\EvdepismisTheme;

use Anomaly\Streams\Platform\Addon\AddonServiceProvider;
use Anomaly\Streams\Platform\Ui\Form\Event\FormWasPosted;
use Anomaly\Streams\Platform\Ui\Form\Event\FormWasSaved;
use Illuminate\Routing\Router;
use Illuminate\Support\Facades\View;

class EvdepismisThemeServiceProvider extends AddonServiceProvider
{
    protected $plugins = [
        EvdepismisThemePlugin::class
    ];

    protected $routes = [
        'mapIndex' => [
            'as' => 'visiosoft.theme.evdepismis::mapIndex',
            'uses' => 'Visiosoft\EvdepismisTheme\Http\Controller\EvdepismisController@returnMapIndex',
        ],
        'api/ep/stores-distance' => 'Visiosoft\EvdepismisTheme\Http\Controller\EvdepismisController@getStoresByCoordinates',
        'api/ep/book-table' => [
            'as' => 'visiosoft.theme.evdepismis::bookTable',
            'uses' => 'Visiosoft\EvdepismisTheme\Http\Controller\EvdepismisController@bookTable'
        ],
        'api/ep/check-bookmark/{id}/{type}' => 'Visiosoft\EvdepismisTheme\Http\Controller\EvdepismisController@checkBookmark',
        'api/ep/toggle-bookmark' => 'Visiosoft\EvdepismisTheme\Http\Controller\EvdepismisController@toggleBookmark',
        'api/ep/change-online-status' => 'Visiosoft\EvdepismisTheme\Http\Controller\EvdepismisController@changeOnlineStatus',
    ];

    protected $listeners = [
        FormWasPosted::class => [
            '\Visiosoft\EvdepismisTheme\Listeners\SaveIdentificationNumber'
        ],
        FormWasSaved::class => [
            '\Visiosoft\EvdepismisTheme\Listeners\DeleteCarrierFieldData'
        ],
    ];

    protected $overrides = [
        'streams::errors/404' => 'visiosoft.theme.base::errors/404',
        'streams::errors/403' => 'visiosoft.theme.base::errors/403',
        'anomaly.module.users::login' => 'visiosoft.theme.base::addons/anomaly/users-module/login',
        'anomaly.module.users::register' => 'visiosoft.theme.base::addons/anomaly/users-module/register',
        'anomaly.module.users::password/forgot' => 'visiosoft.theme.base::addons/anomaly/users-module/password/forgot',
        'anomaly.module.users::password/reset' => 'visiosoft.theme.base::addons/anomaly/users-module/password/reset',
        'visiosoft.module.advs::new-ad/preview/partials/preview-window' => 'visiosoft.theme.evdepismis::addons/visiosoft/advs-module/new-ad/preview/partials/preview-window',
    ];

    public function boot()
    {
        if (request()->path() == '/') {
            View::composer('*', function (\Illuminate\View\View $view) {
                try {
                    $location = file_get_contents("https://ipinfo.io/json");
                    $location = json_decode($location, true);
                    $view->with('location', $location);
                } catch (\Exception $exception) {
                    $view->with('currentCity', null);
                }
            });
        }
    }

    public function map(Router $router)
    {
        $router->get(
            'store/list', [
                'as' => 'store::ep.list',
                'uses' => 'Visiosoft\EvdepismisTheme\Http\Controller\EvdepismisController@listStores'
            ]
        );
    }
}
