let map, geocoder, infoWindow, marker

function initMap() {
    const options = {
        zoom: 15,
    };
    geocoder = new google.maps.Geocoder();
    map = new google.maps.Map(document.getElementById("map"), options);
    marker = new google.maps.Marker({ map })

    google.maps.event.addListener(map, 'click', function (event) {
        placeMarker(event.latLng);
    });

    infoWindow = new google.maps.InfoWindow;
    geocodeAddress(defaultCountry.name)
}

function geocodeAddress(address) {
    geocoder.geocode({ address: address }, (results, status) => {
        if (status === "OK") {
            map.setCenter(results[0].geometry.location);
            map.fitBounds(results[0].geometry.viewport)

            placeMarker(results[0].geometry.location)
        }
    });
}

function placeMarker(location) {
    marker.setPosition(location)

    $('#lat').val(location.lat())
    console.log($('#lat').val())
    $('#lng').val(location.lng())
}

$("#searchLocation").keyup(function() {
    const location = $(this).val()
    if (location) {
        geocodeAddress(location)
    }
});
