<?php namespace Visiosoft\EmlaktownTheme;

use Anomaly\SettingsModule\Setting\Contract\SettingRepositoryInterface;
use Anomaly\Streams\Platform\Assignment\Contract\AssignmentRepositoryInterface;
use Anomaly\Streams\Platform\Database\Seeder\Seeder;
use Anomaly\Streams\Platform\Field\Contract\FieldRepositoryInterface;
use Anomaly\Streams\Platform\Stream\Contract\StreamRepositoryInterface;
use Illuminate\Support\Facades\Artisan;

class EmlaktownThemeSeeder extends Seeder
{

    private $fieldRepository;
    private $streamRepository;
    private $assignmentRepository;
    private $settingRepository;

    public function __construct(
        FieldRepositoryInterface $fieldRepository,
        StreamRepositoryInterface $streamRepository,
        AssignmentRepositoryInterface $assignmentRepository,
        SettingRepositoryInterface $settingRepository
    )
    {
        parent::__construct();
        $this->fieldRepository = $fieldRepository;
        $this->streamRepository = $streamRepository;
        $this->assignmentRepository = $assignmentRepository;
        $this->settingRepository = $settingRepository;
    }

    /**
     * Run the seeder.
     */
    public function run()
    {
        $defaultPagesStream = $this->streamRepository->findBySlugAndNamespace('default_pages', 'pages');

        // Create homepage categories repeater
        $homepageCategoriesRepeater = $this->streamRepository
            ->findBySlugAndNamespace('homepage_categories', 'repeater');
        if ($homepageCategoriesRepeater) {
            $homepageCategoriesRepeater->delete();
        }
        $homepageCategoriesRepeater = $this->streamRepository->create([
            'name' => 'Homepage Categories',
            'namespace' => 'repeater',
            'slug' => 'homepage_categories',
            'prefix' => 'repeater_',
        ]);

        // Create sub nav categories repeater
        $subNavCategoriesRepeater = $this->streamRepository
            ->findBySlugAndNamespace('sub_nav_categories', 'repeater');
        if ($subNavCategoriesRepeater) {
            $subNavCategoriesRepeater->delete();
        }
        $subNavCategoriesRepeater = $this->streamRepository->create([
            'name' => 'Sub Nav Categories',
            'namespace' => 'repeater',
            'slug' => 'sub_nav_categories',
            'prefix' => 'repeater_',
        ]);

        // Assign repeater fields
        $homepageCategoriesFields = [
            'category' => [
                'name' => 'Category',
                'namespace' => 'repeater',
                'slug' => 'category',
                'type' => 'anomaly.field_type.relationship',
                "config" => [
                    "related" => '\Visiosoft\CatsModule\Category\CategoryModel',
                    "mode" => "lookup",
                ],
                "assignment_config" => [
                    'required' => true,
                ]
            ],
            'description' => [
                'name' => 'Description',
                'namespace' => 'repeater',
                'slug' => 'description',
                'type' => 'anomaly.field_type.text',
                "config" => [
                    "type" => 'text',
                ],
                "assignment_config" => [
                    'required' => true,
                    'translatable' => true
                ]
            ]
        ];

        $catField = null;
        foreach ($homepageCategoriesFields as $homepageCategoriesField) {
            $field = $this->fieldRepository
                ->findBySlugAndNamespace($homepageCategoriesField['slug'], $homepageCategoriesField['namespace']);
            if ($field) {
                $field->delete();
            }
            $field = $this->fieldRepository->create([
                'name' => $homepageCategoriesField['name'],
                'namespace' => $homepageCategoriesField['namespace'],
                'slug' => $homepageCategoriesField['slug'],
                'type' => $homepageCategoriesField['type'],
                'locked' => 0,
                "config" => $homepageCategoriesField['config']
            ]);
            $catField = $catField ?: $field;
            $this->assignmentRepository->create([
                'stream_id' => $homepageCategoriesRepeater->getId(),
                'field_id' => $field->id,
                'label' => $homepageCategoriesField['name'],
                'config' => $homepageCategoriesField['assignment_config']
            ]);
        }

        $this->assignmentRepository->create([
            'stream_id' => $subNavCategoriesRepeater->getId(),
            'field_id' => $catField->id,
            'label' => $homepageCategoriesFields['category']['name'],
            'config' => $homepageCategoriesFields['category']['assignment_config']
        ]);

        // Assign pages fields
        $pagesFields = [
            'homepage_categories' => [
                'name' => 'Homepage Categories',
                'namespace' => 'pages',
                'slug' => 'homepage_categories',
                'type' => 'anomaly.field_type.repeater',
                "config" => [
                    "related" => '\Anomaly\Streams\Platform\Model\Repeater\RepeaterHomepageCategoriesEntryModel',
                    "max" => 3,
                ]
            ],
            'sub_nav_categories' => [
                'name' => 'Sub Nav Categories',
                'namespace' => 'pages',
                'slug' => 'sub_nav_categories',
                'type' => 'anomaly.field_type.repeater',
                "config" => [
                    "related" => '\Anomaly\Streams\Platform\Model\Repeater\RepeaterSubNavCategoriesEntryModel',
                    "max" => 4,
                ]
            ],
        ];

        foreach ($pagesFields as $pagesField) {
            $field = $this->fieldRepository->findBySlugAndNamespace($pagesField['slug'], $pagesField['namespace']);
            if ($field) {
                $field->delete();
            }
            $field = $this->fieldRepository->create([
                'name' => $pagesField['name'],
                'namespace' => $pagesField['namespace'],
                'slug' => $pagesField['slug'],
                'type' => $pagesField['type'],
                'locked' => 0,
                "config" => $pagesField['config']
            ]);
            $this->assignmentRepository->create([
                'stream_id' => $defaultPagesStream->getId(),
                'field_id' => $field->id,
                'label' => $pagesField['name'],
            ]);
        }

        // Activate
        $this->settingRepository->set('streams::standard_theme', 'visiosoft.theme.emlaktown');
        Artisan::call('assets:clear');
    }
}