<?php namespace Visiosoft\EmlaktownTheme;

use Anomaly\NavigationModule\Menu\Contract\MenuRepositoryInterface;
use Anomaly\SettingsModule\Setting\Contract\SettingRepositoryInterface;
use Anomaly\Streams\Platform\Assignment\Contract\AssignmentRepositoryInterface;
use Anomaly\Streams\Platform\Database\Seeder\Seeder;
use Anomaly\Streams\Platform\Field\Contract\FieldRepositoryInterface;
use Anomaly\Streams\Platform\Stream\Contract\StreamRepositoryInterface;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\DB;

class EmlaktownThemeSeeder extends Seeder
{

    private $fieldRepository;
    private $streamRepository;
    private $assignmentRepository;
    private $settingRepository;
    private $menuRepository;

    public function __construct(
        FieldRepositoryInterface $fieldRepository,
        StreamRepositoryInterface $streamRepository,
        AssignmentRepositoryInterface $assignmentRepository,
        SettingRepositoryInterface $settingRepository,
        MenuRepositoryInterface $menuRepository
    )
    {
        parent::__construct();
        $this->fieldRepository = $fieldRepository;
        $this->streamRepository = $streamRepository;
        $this->assignmentRepository = $assignmentRepository;
        $this->settingRepository = $settingRepository;
        $this->menuRepository = $menuRepository;
    }

    /**
     * Run the seeder.
     */
    public function run()
    {
        $defaultPagesStream = $this->streamRepository->findBySlugAndNamespace('default_pages', 'pages');

        // Create homepage categories repeater
        $homepageCategoriesRepeater = $this->streamRepository
            ->findBySlugAndNamespace('homepage_categories', 'repeater');
        if ($homepageCategoriesRepeater) {
            $homepageCategoriesRepeater->delete();
        }
        $homepageCategoriesRepeater = $this->streamRepository->create([
            'name' => 'Homepage Categories',
            'namespace' => 'repeater',
            'slug' => 'homepage_categories',
            'prefix' => 'repeater_',
        ]);

        // Assign repeater fields
        $homepageCategoriesFields = [
            'category' => [
                'name' => 'Category',
                'namespace' => 'repeater',
                'slug' => 'category',
                'type' => 'anomaly.field_type.relationship',
                "config" => [
                    "related" => '\Visiosoft\CatsModule\Category\CategoryModel',
                    "mode" => "lookup",
                ],
                "assignment_config" => [
                    'required' => true,
                ]
            ],
            'description' => [
                'name' => 'Description',
                'namespace' => 'repeater',
                'slug' => 'description',
                'type' => 'anomaly.field_type.text',
                "config" => [
                    "type" => 'text',
                ],
                "assignment_config" => [
                    'required' => true,
                    'translatable' => true
                ]
            ],
            'url' => [
                'name' => 'Url',
                'namespace' => 'repeater',
                'slug' => 'url',
                'type' => 'anomaly.field_type.text',
                "config" => [
                    "type" => 'text',
                ],
                "assignment_config" => [
                    'required' => true,
                    'translatable' => false
                ]
            ]
        ];

        $catField = null;
        foreach ($homepageCategoriesFields as $homepageCategoriesField) {
            $field = $this->fieldRepository
                ->findBySlugAndNamespace($homepageCategoriesField['slug'], $homepageCategoriesField['namespace']);
            if ($field) {
                $field->delete();
            }
            $field = $this->fieldRepository->create([
                'name' => $homepageCategoriesField['name'],
                'namespace' => $homepageCategoriesField['namespace'],
                'slug' => $homepageCategoriesField['slug'],
                'type' => $homepageCategoriesField['type'],
                'locked' => 0,
                "config" => $homepageCategoriesField['config']
            ]);
            $catField = $catField ?: $field;
            $this->assignmentRepository->create([
                'stream_id' => $homepageCategoriesRepeater->getId(),
                'field_id' => $field->id,
                'label' => $homepageCategoriesField['name'],
                'config' => $homepageCategoriesField['assignment_config']
            ]);
        }

        // Assign pages fields
        $pagesFields = [
            'homepage_categories' => [
                'name' => 'Homepage Categories',
                'namespace' => 'pages',
                'slug' => 'homepage_categories',
                'type' => 'anomaly.field_type.repeater',
                "config" => [
                    "related" => '\Anomaly\Streams\Platform\Model\Repeater\RepeaterHomepageCategoriesEntryModel',
                    "max" => 3,
                ]
            ],
        ];

        foreach ($pagesFields as $pagesField) {
            $field = $this->fieldRepository->findBySlugAndNamespace($pagesField['slug'], $pagesField['namespace']);
            if ($field) {
                $field->delete();
            }
            $field = $this->fieldRepository->create([
                'name' => $pagesField['name'],
                'namespace' => $pagesField['namespace'],
                'slug' => $pagesField['slug'],
                'type' => $pagesField['type'],
                'locked' => 0,
                "config" => $pagesField['config']
            ]);
            $this->assignmentRepository->create([
                'stream_id' => $defaultPagesStream->getId(),
                'field_id' => $field->id,
                'label' => $pagesField['name'],
            ]);
        }

        // Create sub nav menu
        $subNav = $this->menuRepository->findBySlug('subnav');
        if (!$subNav) {
            $this->menuRepository->create([
                'name' => trans('visiosoft.theme.emlaktown::field.subnav'),
                'slug' => 'subnav',
            ]);
        }

        // Activate
        $this->settingRepository->set('streams::standard_theme', 'visiosoft.theme.emlaktown');

	    // Seeder
	    Model::unguard();
	    DB::unprepared(file_get_contents(__DIR__.'/emlaktown_demodata.sql'));
	    Model::reguard();

	    $zip = new \ZipArchive();
	    $zip->open(__DIR__.'/images.zip', \ZipArchive::CREATE);
	    $zip->extractTo(storage_path('streams/default/files-module/local/images/'));
	    $zip->close();

	    Artisan::call('assets:clear');
    }
}