/* Swiper script */
const breakpoint = window.matchMedia( '(min-width: 768px)' );
let mySwiper;

const breakpointChecker = function() {
    if (breakpoint.matches === true) {
        return enableSwiper();
    } else if (breakpoint.matches === false) {
        if ( mySwiper !== undefined ) mySwiper.destroy( true, true );
        return;
    }
};

const enableSwiper = function() {
    mySwiper = new Swiper ('.swiper-container', {
        slidesPerView: 2,
        spaceBetween: 20,
        navigation: {
            nextEl: '.swiper-button-next',
            prevEl: '.swiper-button-prev',
        },
        breakpoints: {
            768: {
                slidesPerView: 3,
            },
            992: {
                slidesPerView: 4,
            },
            1200: {
                slidesPerView: 5,
            },
        },
    });
};

breakpoint.addListener(breakpointChecker);
breakpointChecker();
/* End Swiper script */
