/* Swiper script */
const breakpoint = window.matchMedia( '(min-width: 768px)' );
let etSwiper;

const breakpointChecker = function() {
    if (breakpoint.matches === true) {
        return enableSwiper();
    } else if (breakpoint.matches === false) {
        if ( etSwiper !== undefined ) etSwiper.destroy( true, true );
        return;
    }
};

const enableSwiper = function() {
    etSwiper = new Swiper ('.et-featured-slider', {
        slidesPerView: 2,
        spaceBetween: 20,
        navigation: {
            nextEl: '.swiper-button-next',
            prevEl: '.swiper-button-prev',
        },
        breakpoints: {
            768: {
                slidesPerView: 3,
            },
            992: {
                slidesPerView: 4,
            },
            1200: {
                slidesPerView: 5,
            },
        },
    });
};

breakpoint.addListener(breakpointChecker);
breakpointChecker();

const blogSwiper = new Swiper ('.blog', {
    slidesPerView: 2,
    spaceBetween: 10,
    navigation: {
        nextEl: '.swiper-button-next',
        prevEl: '.swiper-button-prev',
    },
    breakpoints: {
        992: {
            slidesPerView: 3,
        },
        1200: {
            slidesPerView: 4,
        },
    },
});
/* End Swiper script */
