<?php namespace Visiosoft\Emlak24mTheme\Seed;

use Illuminate\Database\Seeder;
use Illuminate\Support\Str;
use Visiosoft\CatsModule\Category\Contract\CategoryRepositoryInterface;
use Visiosoft\CustomfieldsModule\CustomField\Contract\CustomFieldRepositoryInterface;
use Visiosoft\CustomfieldsModule\Parent\Contract\ParentRepositoryInterface;

class CustomfieldSeed extends Seeder
{
    protected $customFieldRepository;
    protected $parentRepository;
    protected $categoryRepository;

    public function __construct(
        CustomFieldRepositoryInterface $customFieldRepository,
        ParentRepositoryInterface $parentRepository,
        CategoryRepositoryInterface $categoryRepository
    )
    {
        $this->customFieldRepository = $customFieldRepository;
        $this->parentRepository = $parentRepository;
        $this->categoryRepository = $categoryRepository;
    }

    public function run()
    {
        $customFields = [
            'housing_types' => [
                'name' => 'Housing Types',
                'type' => 'text',
                'cat_id' => $this->categoryRepository->findBySlug('projects')->getId(),
                'seenList' => 0,
            ],
            'number_of_houses' => [
                'name' => 'Number of Houses',
                'type' => 'text',
                'cat_id' => $this->categoryRepository->findBySlug('projects')->getId(),
                'seenList' => 0,
            ],
            'delivery_date' => [
                'name' => 'Delivery Date',
                'type' => 'text',
                'cat_id' => $this->categoryRepository->findBySlug('projects')->getId(),
                'seenList' => 0,
            ],
            'gross' => [
                'name' => 'Gross',
                'type' => 'text',
                'seenList' => 1,
            ],
            'floor_location' => [
                'name' => 'Floor Location',
                'type' => 'text',
                'seenList' => 1,
            ],
            'number_of_rooms' => [
                'name' => 'Number Of Rooms',
                'type' => 'text',
                'seenList' => 1,
            ],
        ];

        foreach ($customFields as $key => $customField) {
            if (!$cf = $this->customFieldRepository->findBySlug($key)) {
                $cf = $this->customFieldRepository->create([
                    'slug' => $key,
                    'name' => $customField['name'],
                    'type' => $customField['type'],
                    'seenList' => $customField['seenList'],
                ]);
            }

            if (array_key_exists('cat_id', $customField)) {
                $this->parentRepository->createNew($cf->getId(), $customField['cat_id']);
            }
        }
    }
}
